/*
 * Decompiled with CFR 0.152.
 */
package cubex2.advInv.data;

import cubex2.advInv.data.CapabilityHandler;
import cubex2.advInv.item.AreaUpgrade;
import cubex2.advInv.item.ItemAreaUpgrade;
import cubex2.advInv.lib.ModItems;
import java.util.concurrent.Callable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ExtendedPlayerInv
implements ICapabilitySerializable<NBTTagCompound>,
IInventory {
    public static final ResourceLocation PROPS_NAME = new ResourceLocation("advinv", "AdvInv");
    private EntityPlayer player;
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)73, (Object)ItemStack.field_190927_a);
    private int lastSelectedArea = -1;

    public ExtendedPlayerInv(EntityPlayer player) {
        this.player = player;
    }

    public int getUpgradeNumber() {
        ItemStack stack = (ItemStack)this.stacks.get(54);
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b() == ModItems.InvModule) {
            return MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)5) + 1;
        }
        return 0;
    }

    public boolean isAreaEnabled(int area) {
        return this.getUpgradeNumber() > area;
    }

    public ItemStack getAreaUpgrade(int area, int slot) {
        if (area < 0 || slot < 0) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.stacks.get(55 + area * 3 + slot);
    }

    public ItemStack getUpgrade(int area, AreaUpgrade type) {
        int index = this.getUpgradeIndex(area, type);
        if (index == -1) {
            return ItemStack.field_190927_a;
        }
        return this.getAreaUpgrade(area, index);
    }

    public boolean hasUpgrade(int area, AreaUpgrade type) {
        return this.getUpgradeIndex(area, type) != -1;
    }

    private int getUpgradeIndex(int area, AreaUpgrade type) {
        if (area < 0) {
            return -1;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack upgrade = this.getAreaUpgrade(area, i);
            if (!ItemAreaUpgrade.isUpgrade(upgrade, type)) continue;
            return i;
        }
        return -1;
    }

    public boolean canPutInArea(int area, int slot, ItemStack stack) {
        if (!this.isAreaEnabled(area)) {
            return false;
        }
        if (!this.hasUpgrade(area, AreaUpgrade.FILTER)) {
            return true;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack upgrade = this.getAreaUpgrade(area, i);
            if (!ItemAreaUpgrade.isUpgrade(upgrade, AreaUpgrade.FILTER)) continue;
            boolean matchPosition = ItemAreaUpgrade.getMatchPosition(upgrade);
            NonNullList<ItemStack> stacks = ItemAreaUpgrade.getFilterItems(upgrade);
            if (matchPosition) {
                return ((ItemStack)stacks.get(slot)).func_190926_b() || ((ItemStack)stacks.get(slot)).func_77969_a(stack);
            }
            for (ItemStack filter : stacks) {
                if (filter.func_190926_b() || !filter.func_77969_a(stack)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isVoided(int area, ItemStack stack) {
        if (!this.isAreaEnabled(area)) {
            return false;
        }
        if (!this.hasUpgrade(area, AreaUpgrade.VOID)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack upgrade = this.getAreaUpgrade(area, i);
            if (!ItemAreaUpgrade.isUpgrade(upgrade, AreaUpgrade.VOID)) continue;
            NonNullList<ItemStack> stacks = ItemAreaUpgrade.getVoidItems(upgrade);
            for (ItemStack filter : stacks) {
                if (filter.func_190926_b() || !filter.func_77969_a(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack getStack(int area, int slot) {
        return this.func_70301_a(area * 9 + slot);
    }

    public void setStack(int area, int slot, ItemStack stack) {
        this.func_70299_a(area * 9 + slot, stack);
    }

    public void setLastSelectedArea(int area) {
        this.lastSelectedArea = area;
    }

    public int getLastSelectedArea() {
        return this.lastSelectedArea;
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).func_190926_b()) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.stacks.get(i)).func_77955_b(nbt);
            tagList.func_74742_a((NBTBase)nbt);
        }
        compound.func_74782_a("AdvInvItems", (NBTBase)tagList);
        compound.func_74774_a("LastArea", (byte)this.lastSelectedArea);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagList tagList = compound.func_150295_c("AdvInvItems", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbt = tagList.func_150305_b(i);
            int j = nbt.func_74771_c("Slot") & 0xFF;
            ItemStack stack = new ItemStack(nbt);
            if (stack.func_190926_b() || j >= this.stacks.size()) continue;
            this.stacks.set(j, (Object)stack);
        }
        this.lastSelectedArea = compound.func_74771_c("LastArea");
    }

    public void func_174888_l() {
        this.stacks.clear();
    }

    public static ExtendedPlayerInv get(EntityPlayer player) {
        return (ExtendedPlayerInv)player.getCapability(CapabilityHandler.EXTENDED_INV_CAPABILITY, null);
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.stacks) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.stacks.get(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = ItemStackHelper.func_188382_a(this.stacks, (int)slot, (int)amount);
        if (!itemStack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        return ItemStackHelper.func_188383_a(this.stacks, (int)slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (!stack.func_190926_b() && this.isVoided(slot / 9, stack)) {
            stack = ItemStack.field_190927_a;
        }
        this.stacks.set(slot, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return "advInv";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (i >= 54) {
            return false;
        }
        int area = i / 9;
        int slot = i % 9;
        return this.canPutInArea(area, slot, stack);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void copyInventory(ExtendedPlayerInv inv) {
        for (int i = 0; i < this.stacks.size(); ++i) {
            this.stacks.set(i, (Object)((ItemStack)inv.stacks.get(i)).func_77946_l());
        }
    }

    public boolean addItemStackToInventory(final ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_190916_E() != 0) {
            try {
                int i;
                if (stack.func_77951_h()) {
                    int i2 = this.getFirstEmptyStack(stack);
                    if (i2 >= 0) {
                        this.stacks.set(i2, (Object)stack.func_77946_l());
                        ((ItemStack)this.stacks.get(i2)).func_190915_d(5);
                        stack.func_190920_e(0);
                        return true;
                    }
                    if (this.player.field_71075_bZ.field_75098_d) {
                        stack.func_190920_e(0);
                        return true;
                    }
                    return false;
                }
                do {
                    i = stack.func_190916_E();
                    stack.func_190920_e(this.storePartialItemStack(stack));
                } while (stack.func_190916_E() > 0 && stack.func_190916_E() < i);
                if (stack.func_190916_E() == i && this.player.field_71075_bZ.field_75098_d) {
                    stack.func_190920_e(0);
                    return true;
                }
                return stack.func_190916_E() < i;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Adding item to inventory");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Item being added");
                crashreportcategory.func_71507_a("Item ID", (Object)Item.func_150891_b((Item)stack.func_77973_b()));
                crashreportcategory.func_71507_a("Item data", (Object)stack.func_77952_i());
                crashreportcategory.func_71507_a("Item name", (Object)new Callable(){

                    public String call() {
                        return stack.func_82833_r();
                    }
                });
                throw new ReportedException(crashreport);
            }
        }
        return false;
    }

    public int getFirstEmptyStack(ItemStack stack) {
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (!((ItemStack)this.stacks.get(i)).func_190926_b() || !this.func_94041_b(i, stack)) continue;
            return i;
        }
        return -1;
    }

    private int storePartialItemStack(ItemStack stack) {
        Item item = stack.func_77973_b();
        int i = stack.func_190916_E();
        if (stack.func_77976_d() == 1) {
            int j = this.getFirstEmptyStack(stack);
            if (j < 0) {
                return i;
            }
            if (((ItemStack)this.stacks.get(j)).func_190926_b() && this.func_94041_b(j, stack)) {
                this.stacks.set(j, (Object)stack.func_77946_l());
            }
            return 0;
        }
        int j = this.storeItemStack(stack);
        if (j < 0) {
            j = this.getFirstEmptyStack(stack);
        }
        if (j < 0) {
            return i;
        }
        if (((ItemStack)this.stacks.get(j)).func_190926_b() && this.func_94041_b(j, new ItemStack(item, 0, stack.func_77952_i()))) {
            this.stacks.set(j, (Object)new ItemStack(item, 0, stack.func_77952_i()));
            if (stack.func_77942_o()) {
                ((ItemStack)this.stacks.get(j)).func_77982_d(stack.func_77978_p().func_74737_b());
            }
        }
        int k = i;
        if (i > ((ItemStack)this.stacks.get(j)).func_77976_d() - ((ItemStack)this.stacks.get(j)).func_190916_E()) {
            k = ((ItemStack)this.stacks.get(j)).func_77976_d() - ((ItemStack)this.stacks.get(j)).func_190916_E();
        }
        if (k > this.func_70297_j_() - ((ItemStack)this.stacks.get(j)).func_190916_E()) {
            k = this.func_70297_j_() - ((ItemStack)this.stacks.get(j)).func_190916_E();
        }
        if (k == 0) {
            return i;
        }
        ((ItemStack)this.stacks.get(j)).func_190917_f(k);
        ((ItemStack)this.stacks.get(j)).func_190915_d(5);
        return i -= k;
    }

    private int storeItemStack(ItemStack stack) {
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).func_190926_b() || !this.func_94041_b(i, stack) || ((ItemStack)this.stacks.get(i)).func_77973_b() != stack.func_77973_b() || !((ItemStack)this.stacks.get(i)).func_77985_e() || ((ItemStack)this.stacks.get(i)).func_190916_E() >= ((ItemStack)this.stacks.get(i)).func_77976_d() || ((ItemStack)this.stacks.get(i)).func_190916_E() >= this.func_70297_j_() || ((ItemStack)this.stacks.get(i)).func_77981_g() && ((ItemStack)this.stacks.get(i)).func_77952_i() != stack.func_77952_i() || !ItemStack.func_77970_a((ItemStack)((ItemStack)this.stacks.get(i)), (ItemStack)stack)) continue;
            return i;
        }
        return -1;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityHandler.EXTENDED_INV_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityHandler.EXTENDED_INV_CAPABILITY ? this : null);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.saveNBTData(nbt);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.loadNBTData(nbt);
    }
}

