/*
 * Decompiled with CFR 0.152.
 */
package cubex2.advInv.gui;

import cubex2.advInv.AdvInv;
import cubex2.advInv.gui.GuiAdvInv;
import cubex2.advInv.gui.control.Control;
import cubex2.advInv.gui.control.OptionBox;
import cubex2.advInv.item.ItemAreaUpgrade;
import cubex2.advInv.network.PacketSetPriority;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CollectorContent
extends Control {
    private final GuiAdvInv gui;
    private OptionBox obPriority;

    public CollectorContent(int xOffset, int yOffset, int width, int height, Control parent, GuiAdvInv gui) {
        super(xOffset, yOffset, width, height, parent);
        this.gui = gui;
        this.obPriority = new OptionBox(2, 2, this, gui);
        this.obPriority.addOption("1", "Priority", "ob_1");
        this.obPriority.addOption("2", "Priority", "ob_2");
        this.obPriority.addOption("3", "Priority", "ob_3");
        this.obPriority.addOption("4", "Priority", "ob_4");
        this.obPriority.addOption("5", "Priority", "ob_5");
        this.obPriority.addOption("6", "Priority", "ob_6");
        this.children.add(this.obPriority);
    }

    public void selectedAreaChanged(boolean hasCorrectUpgrade) {
        if (hasCorrectUpgrade) {
            int priority = ItemAreaUpgrade.getPriority(this.getAreaUpgrade());
            this.obPriority.setSelectedOption(priority + "");
            this.obPriority.enabled = true;
            this.obPriority.visible = true;
        } else {
            this.obPriority.enabled = false;
            this.obPriority.visible = false;
        }
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY, int button) {
        if (c == this.obPriority && button == 0) {
            int priority = Integer.parseInt(this.obPriority.getSelectedOption());
            ItemAreaUpgrade.setPriority(this.getAreaUpgrade(), priority);
            AdvInv.network.sendToServer((IMessage)new PacketSetPriority(priority, this.gui.upgradeIndex, this.gui.container.field_75152_c));
        }
    }

    private ItemStack getAreaUpgrade() {
        return this.gui.inv.getAreaUpgrade(this.gui.selectedArea, this.gui.upgradeIndex);
    }
}

