/*
 * Decompiled with CFR 0.152.
 */
package cubex2.advInv.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cubex2.advInv.Util;
import cubex2.advInv.data.ExtendedPlayerInv;
import cubex2.advInv.gui.GuiAdvInv;
import cubex2.advInv.gui.SlotChangedListener;
import cubex2.advInv.item.AreaUpgrade;
import cubex2.advInv.item.ItemAreaUpgrade;
import cubex2.advInv.lib.ModItems;
import invtweaks.api.container.ChestContainer;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ChestContainer(rowSize=54, isLargeChest=true)
@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ContainerAdvInv
extends Container {
    private static final EntityEquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    public final EntityPlayer thePlayer;
    public InventoryCrafting craftMatrix = new InventoryCrafting((Container)this, 2, 2);
    public InventoryCraftResult craftResult = new InventoryCraftResult();
    public InventoryCrafting crafterMatrix = new InventoryCrafting((Container)this, 3, 3);
    public InventoryCraftResult crafterResult = new InventoryCraftResult();
    private ExtendedPlayerInv inv;
    private int firstAreaUpgradeSlot;
    private int editingUpgrade = -1;
    private int selectedArea = -1;
    public SlotChangedListener listener;
    private Slot crafterSlot;
    private Slot[] crafterMatrixSlots = new Slot[9];

    public ContainerAdvInv(InventoryPlayer inventory, final ExtendedPlayerInv inv, EntityPlayer player) {
        int j;
        int i;
        int i2;
        this.thePlayer = player;
        this.inv = inv;
        int mainX = 58;
        int mainY = 77;
        this.func_75146_a((Slot)new SlotCrafting(player, this.craftMatrix, (IInventory)this.craftResult, 0, mainX + 144, mainY + 18));
        for (i2 = 0; i2 < 2; ++i2) {
            for (int j2 = 0; j2 < 2; ++j2) {
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, j2 + i2 * 2, mainX + 88 + j2 * 18, mainY + 8 + i2 * 18));
            }
        }
        for (i2 = 0; i2 < 4; ++i2) {
            final EntityEquipmentSlot entityequipmentslot = VALID_EQUIPMENT_SLOTS[i2];
            this.func_75146_a(new Slot((IInventory)inventory, 36 + (3 - i2), mainX + 8, mainY + 8 + i2 * 18){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack stack) {
                    if (stack.func_190926_b()) {
                        return false;
                    }
                    return stack.func_77973_b().isValidArmor(stack, entityequipmentslot, (Entity)ContainerAdvInv.this.thePlayer);
                }

                @SideOnly(value=Side.CLIENT)
                public String func_178171_c() {
                    return ItemArmor.field_94603_a[entityequipmentslot.func_188454_b()];
                }
            });
        }
        for (i2 = 0; i2 < 3; ++i2) {
            for (int j3 = 0; j3 < 9; ++j3) {
                this.func_75146_a(new Slot((IInventory)inventory, j3 + (i2 + 1) * 9, mainX + 8 + j3 * 18, mainY + 84 + i2 * 18));
            }
        }
        for (i2 = 0; i2 < 9; ++i2) {
            this.func_75146_a(new Slot((IInventory)inventory, i2, mainX + 8 + i2 * 18, mainY + 142));
        }
        this.func_75146_a(new Slot((IInventory)inventory, 40, mainX + 80, mainY + 8 + 54){

            @SideOnly(value=Side.CLIENT)
            public String func_178171_c() {
                return "minecraft:items/empty_armor_slot_shield";
            }
        });
        int slotId = 0;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 2; ++j) {
                int top = i * 77;
                int left = j == 0 ? 0 : 230;
                final int spaceId = j + i * 2;
                for (int k = 0; k < 3; ++k) {
                    for (int l = 0; l < 3; ++l) {
                        int xOffset = j == 0 ? 8 : 2;
                        final int areaSlot = l + k * 3;
                        this.func_75146_a(new Slot(inv, slotId++, left + xOffset + l * 18, top + 8 + k * 18){

                            public boolean func_75214_a(ItemStack stack) {
                                return inv.canPutInArea(spaceId, areaSlot, stack);
                            }
                        });
                    }
                }
            }
        }
        this.func_75146_a(new Slot(inv, slotId++, mainX + 116, 139){

            public int func_75219_a() {
                return 1;
            }

            public boolean func_75214_a(ItemStack stack) {
                return stack.func_190926_b() || stack.func_77973_b() == ModItems.InvModule;
            }

            public void func_75218_e() {
                super.func_75218_e();
                if (ContainerAdvInv.this.listener != null) {
                    ContainerAdvInv.this.listener.onSlotChanged(this.getSlotIndex());
                }
            }

            @SideOnly(value=Side.CLIENT)
            public String func_178171_c() {
                return "advinv:items/empty_module";
            }
        });
        this.firstAreaUpgradeSlot = this.field_75151_b.size();
        for (i = 0; i < 6; ++i) {
            final int area = i;
            for (int j4 = 0; j4 < 3; ++j4) {
                this.func_75146_a(new Slot(inv, slotId++, mainX + 8, -1992 + j4 * 18){

                    public int func_75219_a() {
                        return 1;
                    }

                    public boolean func_75214_a(ItemStack stack) {
                        boolean isFilter = ItemAreaUpgrade.isUpgrade(stack, AreaUpgrade.FILTER);
                        boolean isProvider = ItemAreaUpgrade.isUpgrade(stack, AreaUpgrade.PROVIDER);
                        boolean isCollector = ItemAreaUpgrade.isUpgrade(stack, AreaUpgrade.COLLECTOR);
                        boolean hasFilter = inv.hasUpgrade(area, AreaUpgrade.FILTER);
                        boolean hasProvider = inv.hasUpgrade(area, AreaUpgrade.PROVIDER);
                        boolean hasCollector = inv.hasUpgrade(area, AreaUpgrade.COLLECTOR);
                        if (isFilter && hasFilter) {
                            return false;
                        }
                        if (isProvider && (hasProvider || hasCollector)) {
                            return false;
                        }
                        if (isCollector && hasProvider) {
                            return false;
                        }
                        return stack.func_77973_b() == ModItems.AreaUpgrade;
                    }

                    public void func_75218_e() {
                        super.func_75218_e();
                        if (ContainerAdvInv.this.listener != null) {
                            ContainerAdvInv.this.listener.onSlotChanged(this.getSlotIndex());
                        }
                    }

                    public String func_178171_c() {
                        return "advinv:items/empty_upgrade";
                    }
                });
            }
        }
        this.crafterSlot = this.func_75146_a((Slot)new SlotCrafting(player, this.crafterMatrix, (IInventory)this.crafterResult, 0, -2000, -2000){

            public boolean func_82869_a(EntityPlayer player) {
                return ContainerAdvInv.this.hasRecipeItems();
            }

            public ItemStack func_190901_a(EntityPlayer player, ItemStack stack) {
                NonNullList<ItemStack> stacks = Util.copyStacks((IInventory)ContainerAdvInv.this.crafterMatrix);
                super.func_190901_a(player, stack);
                Util.removeFromInventory(stacks, inv, ContainerAdvInv.this.selectedArea * 9, ContainerAdvInv.this.selectedArea * 9 + 9);
                for (int i = 0; i < 9; ++i) {
                    ItemStack stack1 = ContainerAdvInv.this.crafterMatrix.func_70301_a(i);
                    if (stack1.func_190926_b() || inv.addItemStackToInventory(stack1) || player.field_71071_by.func_70441_a(stack1)) continue;
                    player.func_71019_a(stack1, false);
                }
                ContainerAdvInv.this.recipeChanged();
                return stack;
            }
        });
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.crafterMatrixSlots[j + i * 3] = this.func_75146_a(new Slot((IInventory)this.crafterMatrix, j + i * 3, -2000 + j * 18, -2000 + i * 18));
            }
        }
        this.func_75130_a((IInventory)this.craftMatrix);
        this.func_75130_a((IInventory)this.crafterMatrix);
        this.setSelectedArea(inv.getLastSelectedArea());
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        listener.func_71112_a((Container)this, 0, this.selectedArea);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        if (id == 0) {
            Minecraft mc = FMLClientHandler.instance().getClient();
            if (mc.field_71462_r != null && mc.field_71462_r instanceof GuiAdvInv) {
                ((GuiAdvInv)mc.field_71462_r).setSelectedArea(data);
            }
        }
    }

    public void setEditingUpgrade(int value) {
        ItemStack stack;
        if (this.selectedArea == -1) {
            value = -1;
        }
        this.editingUpgrade = value;
        if (this.editingUpgrade == -1) {
            this.crafterSlot.field_75223_e = -2000;
            this.crafterSlot.field_75221_f = -2000;
        }
        if (ItemAreaUpgrade.isUpgrade(stack = this.inv.getAreaUpgrade(this.selectedArea, this.editingUpgrade), AreaUpgrade.CRAFTER)) {
            this.crafterSlot.field_75223_e = 208;
            this.crafterSlot.field_75221_f = 26;
        } else {
            this.crafterSlot.field_75223_e = -2000;
            this.crafterSlot.field_75221_f = -2000;
        }
        this.recipeChanged();
    }

    public void recipeChanged() {
        if (this.selectedArea == -1 || this.editingUpgrade == -1) {
            return;
        }
        ItemStack stack = this.inv.getAreaUpgrade(this.selectedArea, this.editingUpgrade);
        if (ItemAreaUpgrade.isUpgrade(stack, AreaUpgrade.CRAFTER)) {
            int selectedRecipe = ItemAreaUpgrade.getSelectedRecipe(stack);
            NonNullList<ItemStack> recipe = ItemAreaUpgrade.getRecipeItems(stack, selectedRecipe);
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.crafterMatrix.func_70299_a(j + i * 3, ((ItemStack)recipe.get(j + i * 3)).func_77946_l());
                }
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.crafterMatrix.func_70299_a(j + i * 3, ItemStack.field_190927_a);
                }
            }
        }
        this.func_75130_a((IInventory)this.crafterMatrix);
    }

    private boolean hasRecipeItems() {
        if (this.selectedArea == -1 || this.editingUpgrade == -1) {
            return false;
        }
        ItemStack stack1 = this.inv.getAreaUpgrade(this.selectedArea, this.editingUpgrade);
        if (!ItemAreaUpgrade.isUpgrade(stack1, AreaUpgrade.CRAFTER)) {
            return false;
        }
        for (int i = 0; i < this.crafterMatrix.func_70302_i_(); ++i) {
            ItemStack stack = this.crafterMatrix.func_70301_a(i);
            if (stack.func_190926_b() || Util.getAmountInInventory(stack, this.inv, this.selectedArea * 9, this.selectedArea * 9 + 9) >= Util.getAmountInInventory(stack, (IInventory)this.crafterMatrix, 0, 9)) continue;
            return false;
        }
        return true;
    }

    public void setSelectedArea(int area) {
        this.setEditingUpgrade(-1);
        this.selectedArea = MathHelper.func_76125_a((int)area, (int)-1, (int)5);
        this.inv.setLastSelectedArea(this.selectedArea);
        int slotId = this.firstAreaUpgradeSlot;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                Slot slot = (Slot)this.field_75151_b.get(slotId++);
                slot.field_75221_f = i == this.selectedArea ? 8 + j * 18 : -1992 + j * 18;
            }
        }
    }

    public int getSelectedArea() {
        return this.selectedArea;
    }

    public void func_75130_a(IInventory inv) {
        if (inv == this.craftMatrix) {
            this.slotChangedCraftingGrid(this.thePlayer.field_70170_p, this.thePlayer, this.craftMatrix, this.craftResult, 0);
        } else if (inv == this.crafterMatrix) {
            this.slotChangedCraftingGrid(this.thePlayer.field_70170_p, this.thePlayer, this.crafterMatrix, this.crafterResult, this.crafterSlot.field_75222_d);
        }
    }

    protected void slotChangedCraftingGrid(World world, EntityPlayer player, InventoryCrafting matrix, InventoryCraftResult result, int slotId) {
        if (!world.field_72995_K) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)player;
            ItemStack itemstack = ItemStack.field_190927_a;
            IRecipe irecipe = CraftingManager.func_192413_b((InventoryCrafting)matrix, (World)world);
            if (irecipe != null && (irecipe.func_192399_d() || !world.func_82736_K().func_82766_b("doLimitedCrafting") || entityplayermp.func_192037_E().func_193830_f(irecipe))) {
                result.func_193056_a(irecipe);
                itemstack = irecipe.func_77572_b(matrix);
            }
            result.func_70299_a(0, itemstack);
            entityplayermp.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(this.field_75152_c, slotId, itemstack));
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        for (int i = 0; i < 4; ++i) {
            ItemStack itemstack = this.craftMatrix.func_70304_b(i);
            if (itemstack.func_190926_b()) continue;
            player.func_71019_a(itemstack, false);
        }
        this.craftResult.func_70299_a(0, ItemStack.field_190927_a);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            int j;
            ItemStack stack1 = slot.func_75211_c();
            stack = stack1.func_77946_l();
            EntityEquipmentSlot slotType = EntityLiving.func_184640_d((ItemStack)stack);
            if (slotIndex != 100 && stack.func_77973_b() == ModItems.InvModule && !((Slot)this.field_75151_b.get(100)).func_75216_d()) {
                if (!this.func_75135_a(stack1, 100, 101, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (slotIndex == 0) {
                if (!this.func_75135_a(stack1, 9, 45, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(stack1, stack);
            } else if (slotIndex >= 1 && slotIndex < 5 ? !this.func_75135_a(stack1, 9, 45, false) : (slotIndex >= 5 && slotIndex < 9 ? !this.func_75135_a(stack1, 9, 45, false) : (slotType.func_188453_a() == EntityEquipmentSlot.Type.ARMOR && !((Slot)this.field_75151_b.get(8 - slotType.func_188454_b())).func_75216_d() ? !this.func_75135_a(stack1, j = 8 - slotType.func_188454_b(), j + 1, false) : (slotIndex >= 9 && slotIndex < 36 ? !this.func_75135_a(stack1, 46, 100, false) : (slotIndex >= 36 && slotIndex < 45 ? !this.func_75135_a(stack1, 9, 36, false) : !this.func_75135_a(stack1, 9, 45, false)))))) {
                return ItemStack.field_190927_a;
            }
            if (stack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack1.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stack1);
        }
        return stack;
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot.field_75224_c != this.craftResult && super.func_94530_a(stack, slot);
    }

    @ContainerSectionCallback
    public Map<ContainerSection, List<Slot>> getContainerSections() {
        HashMap ret = Maps.newHashMap();
        ArrayList inventory = Lists.newArrayList();
        for (int i = 0; i < 27; ++i) {
            inventory.add(this.func_75139_a(9 + i));
        }
        ret.put(ContainerSection.INVENTORY_NOT_HOTBAR, inventory);
        ArrayList hotbar = Lists.newArrayList();
        for (int i = 27; i < 36; ++i) {
            hotbar.add(this.func_75139_a(9 + i));
        }
        ret.put(ContainerSection.INVENTORY_HOTBAR, hotbar);
        ArrayList chest = Lists.newArrayList();
        for (int i = 45; i < 99; ++i) {
            chest.add((Slot)this.field_75151_b.get(i));
        }
        ret.put(ContainerSection.CHEST, chest);
        return ret;
    }
}

