/*
 * Decompiled with CFR 0.152.
 */
package cubex2.advInv.gui;

import cubex2.advInv.AdvInv;
import cubex2.advInv.gui.GuiAdvInv;
import cubex2.advInv.gui.control.ButtonUpDown;
import cubex2.advInv.gui.control.Control;
import cubex2.advInv.gui.control.FakeSlot;
import cubex2.advInv.item.ItemAreaUpgrade;
import cubex2.advInv.lib.Textures;
import cubex2.advInv.network.PacketFakeSlotClicked;
import cubex2.advInv.network.PacketSetSelectedRecipe;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.ArrayUtils;

public class CrafterContent
extends Control {
    private final GuiAdvInv gui;
    private FakeSlot[] input;
    private ButtonUpDown btnUp;
    private ButtonUpDown btnDown;

    public CrafterContent(int xOffset, int yOffset, int width, int height, Control parent, GuiAdvInv gui) {
        super(xOffset, yOffset, width, height, parent);
        this.gui = gui;
        this.input = new FakeSlot[9];
        int index = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.input[index] = new FakeSlot(j * 18, i * 18, this, gui);
                this.children.add(this.input[index++]);
            }
        }
        this.btnUp = new ButtonUpDown(true, 70, 4, this);
        this.children.add(this.btnUp);
        this.btnDown = new ButtonUpDown(false, 70, 40, this);
        this.children.add(this.btnDown);
    }

    public void selectedAreaChanged(boolean hasCorrectUpgrade) {
        if (hasCorrectUpgrade) {
            for (FakeSlot slot : this.input) {
                slot.enabled = true;
                slot.visible = true;
            }
            int selectedRecipe = ItemAreaUpgrade.getSelectedRecipe(this.getAreaUpgrade());
            this.updateStacks(selectedRecipe);
            this.btnUp.enabled = selectedRecipe > 0;
            this.btnUp.visible = true;
            this.btnDown.enabled = selectedRecipe < 8;
            this.btnDown.visible = true;
            System.out.println("change: " + selectedRecipe);
        } else {
            for (FakeSlot slot : this.input) {
                slot.setStack(ItemStack.field_190927_a);
                slot.visible = false;
                slot.enabled = false;
            }
            this.btnUp.enabled = false;
            this.btnUp.visible = false;
            this.btnDown.enabled = false;
            this.btnDown.visible = false;
        }
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY, int button) {
        int index;
        if ((c == this.btnUp || c == this.btnDown) && button == 0) {
            int selectedRecipe = ItemAreaUpgrade.getSelectedRecipe(this.getAreaUpgrade());
            AdvInv.network.sendToServer((IMessage)new PacketSetSelectedRecipe(selectedRecipe += c == this.btnUp ? -1 : 1, this.gui.upgradeIndex, this.gui.container.field_75152_c));
            this.btnUp.enabled = selectedRecipe > 0;
            this.btnDown.enabled = selectedRecipe < 8;
            ItemAreaUpgrade.setSelectedRecipe(this.getAreaUpgrade(), selectedRecipe);
            this.updateStacks(selectedRecipe);
            this.gui.container.recipeChanged();
        }
        if ((index = ArrayUtils.indexOf((Object[])this.input, (Object)((Object)c))) != -1) {
            FakeSlot slot = this.input[index];
            if (!this.gui.playerInv.func_70445_o().func_190926_b()) {
                ItemStack stack = this.gui.playerInv.func_70445_o().func_77946_l();
                stack.func_190920_e(1);
                slot.setStack(stack);
            } else {
                slot.setStack(ItemStack.field_190927_a);
            }
            int selectedRecipe = ItemAreaUpgrade.getSelectedRecipe(this.getAreaUpgrade());
            ItemAreaUpgrade.setRecipeInput(this.getAreaUpgrade(), slot.getStack(), selectedRecipe, index);
            AdvInv.network.sendToServer((IMessage)new PacketFakeSlotClicked(this.gui.upgradeIndex, index, this.gui.container.field_75152_c));
            this.gui.container.recipeChanged();
        }
    }

    private void updateStacks(int selectedRecipe) {
        NonNullList<ItemStack> stacks = ItemAreaUpgrade.getRecipeItems(this.getAreaUpgrade(), selectedRecipe);
        for (int i = 0; i < this.input.length; ++i) {
            this.input[i].setStack(((ItemStack)stacks.get(i)).func_77946_l());
        }
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        super.draw(mouseX, mouseY);
        if (this.btnUp.visible) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Textures.GUI_EXTRA.drawPart("arrow", this.x + 55, this.y + 21);
            Textures.GUI_EXTRA.drawPart("slot_enabled", this.x + 70, this.y + 18);
        }
    }

    private ItemStack getAreaUpgrade() {
        return this.gui.inv.getAreaUpgrade(this.gui.selectedArea, this.gui.upgradeIndex);
    }
}

