/*
 * Decompiled with CFR 0.152.
 */
package cubex2.advInv.network;

import cubex2.advInv.Util;
import cubex2.advInv.data.ExtendedPlayerInv;
import cubex2.advInv.gui.ContainerAdvInv;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketEditUpgrade
implements IMessage {
    int upgradeIndex;
    int windowId;

    public PacketEditUpgrade() {
    }

    public PacketEditUpgrade(int upgradeIndex, int windowId) {
        this.upgradeIndex = upgradeIndex;
        this.windowId = windowId;
    }

    public void fromBytes(ByteBuf buffer) {
        this.upgradeIndex = buffer.readByte();
        this.windowId = buffer.readInt();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeByte(this.upgradeIndex);
        buffer.writeInt(this.windowId);
    }

    public static abstract class Handler<T extends PacketEditUpgrade>
    implements IMessageHandler<T, IMessage> {
        public final IMessage onMessage(T message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (Util.checkThreadAndEnqueue(message, this, ctx, (IThreadListener)player.func_71121_q())) {
                return null;
            }
            player.func_143004_u();
            if (player.field_71070_bA.field_75152_c == ((PacketEditUpgrade)message).windowId) {
                ContainerAdvInv container = (ContainerAdvInv)player.field_71070_bA;
                int area = container.getSelectedArea();
                ExtendedPlayerInv inv = ExtendedPlayerInv.get((EntityPlayer)player);
                ItemStack stack = inv.getAreaUpgrade(area, ((PacketEditUpgrade)message).upgradeIndex);
                if (stack.func_190926_b()) {
                    return null;
                }
                this.editUpgrade(message, player, area, inv, stack);
            }
            return null;
        }

        protected abstract void editUpgrade(T var1, EntityPlayerMP var2, int var3, ExtendedPlayerInv var4, ItemStack var5);
    }
}

