/*
 * Decompiled with CFR 0.152.
 */
package cubex2.advInv;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class Util {
    public static <T extends IMessage> boolean checkThreadAndEnqueue(final T message, final IMessageHandler<T, IMessage> handler, final MessageContext ctx, IThreadListener listener) {
        if (!listener.func_152345_ab()) {
            listener.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    handler.onMessage(message, ctx);
                }
            });
            return true;
        }
        return false;
    }

    public static void writeStacksToNBT(String name, NonNullList<ItemStack> stacks, NBTTagCompound nbt) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < stacks.size(); ++i) {
            if (((ItemStack)stacks.get(i)).func_190926_b()) continue;
            NBTTagCompound itemNBT = new NBTTagCompound();
            itemNBT.func_74774_a("Slot", (byte)i);
            ((ItemStack)stacks.get(i)).func_77955_b(itemNBT);
            itemList.func_74742_a((NBTBase)itemNBT);
        }
        nbt.func_74782_a(name, (NBTBase)itemList);
    }

    public static void readStacksFromNBT(String name, NonNullList<ItemStack> stacks, NBTTagCompound nbt) {
        NBTTagList itemList = nbt.func_150295_c(name, 10);
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound itemNBT = itemList.func_150305_b(i);
            int slot = itemNBT.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= stacks.size()) continue;
            stacks.set(slot, (Object)new ItemStack(itemNBT));
        }
    }

    public static boolean doStacksFitInInventory(NonNullList<ItemStack> _stacks, EntityPlayerMP player) {
        NonNullList stacks = NonNullList.func_191197_a((int)_stacks.size(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < _stacks.size(); ++i) {
            stacks.set(i, (Object)((ItemStack)_stacks.get(i)).func_77946_l());
        }
        InventoryPlayer inv = new InventoryPlayer((EntityPlayer)player);
        for (int i = 0; i < inv.field_70462_a.size(); ++i) {
            inv.field_70462_a.set(i, (Object)((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77946_l());
        }
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b() || inv.func_70441_a(stack)) continue;
            return false;
        }
        return true;
    }

    public static int getAmountInInventory(ItemStack stack, IInventory inv, int start, int end) {
        if (stack.func_190926_b()) {
            return 0;
        }
        int amount = 0;
        for (int i = start; i < end; ++i) {
            ItemStack stack1 = inv.func_70301_a(i);
            if (stack1.func_190926_b() || !stack.func_77969_a(stack1)) continue;
            amount += stack1.func_190916_E();
        }
        return amount;
    }

    public static NonNullList<ItemStack> copyStacks(IInventory inv) {
        NonNullList stacks = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < stacks.size(); ++i) {
            stacks.set(i, (Object)inv.func_70301_a(i).func_77946_l());
        }
        return stacks;
    }

    public static void removeFromInventory(NonNullList<ItemStack> stacks, IInventory inv, int start, int end) {
        block0: for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            for (int j = start; j < end; ++j) {
                ItemStack stack1 = inv.func_70301_a(j);
                if (stack1.func_190926_b() || !stack1.func_77969_a(stack)) continue;
                stack1.func_190918_g(1);
                if (stack1.func_190916_E() != 0) continue block0;
                inv.func_70299_a(j, ItemStack.field_190927_a);
                continue block0;
            }
        }
    }
}

