/*
 * Decompiled with CFR 0.152.
 */
package cubex2.advInv.gui;

import cubex2.advInv.gui.CollectorContent;
import cubex2.advInv.gui.CrafterContent;
import cubex2.advInv.gui.FilterContent;
import cubex2.advInv.gui.GuiAdvInv;
import cubex2.advInv.gui.ProviderContent;
import cubex2.advInv.gui.VoidContent;
import cubex2.advInv.gui.control.Control;
import cubex2.advInv.item.AreaUpgrade;
import cubex2.advInv.item.ItemAreaUpgrade;
import cubex2.advInv.lib.Textures;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class EditUpgradeArea
extends Control {
    private final GuiAdvInv gui;
    private FilterContent filterContent;
    private ProviderContent providerContent;
    private CollectorContent collectorContent;
    private CrafterContent crafterContent;
    private VoidContent voidContent;

    public EditUpgradeArea(int xOffset, int yOffset, GuiAdvInv gui) {
        super(xOffset, yOffset, 90, 54, null);
        this.gui = gui;
        this.filterContent = new FilterContent(0, 0, this.width, this.height, this, gui);
        this.providerContent = new ProviderContent(0, 0, this.width, this.height, this, gui);
        this.collectorContent = new CollectorContent(0, 0, this.width, this.height, this, gui);
        this.crafterContent = new CrafterContent(0, 0, this.width, this.height, this, gui);
        this.voidContent = new VoidContent(0, 0, this.width, this.height, this, gui);
        this.children.add(this.filterContent);
        this.children.add(this.providerContent);
        this.children.add(this.collectorContent);
        this.children.add(this.crafterContent);
        this.children.add(this.voidContent);
    }

    public void selectedAreaChanged() {
        this.filterContent.selectedAreaChanged(this.hasFilter());
        this.providerContent.selectedAreaChanged(this.hasProvider());
        this.collectorContent.selectedAreaChanged(this.hasCollector());
        this.crafterContent.selectedAreaChanged(this.hasCrafter());
        this.voidContent.selectedAreaChanged(this.hasVoid());
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Textures.GUI_EXTRA.drawPart("edit_area", this.x, this.y);
        super.draw(mouseX, mouseY);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        if (this.gui.playerInv.func_70445_o().func_190926_b()) {
            super.drawForeground(mouseX, mouseY);
        }
    }

    private boolean hasFilter() {
        return ItemAreaUpgrade.isUpgrade(this.getAreaUpgrade(), AreaUpgrade.FILTER);
    }

    private boolean hasProvider() {
        return ItemAreaUpgrade.isUpgrade(this.getAreaUpgrade(), AreaUpgrade.PROVIDER);
    }

    private boolean hasCollector() {
        return ItemAreaUpgrade.isUpgrade(this.getAreaUpgrade(), AreaUpgrade.COLLECTOR);
    }

    private boolean hasCrafter() {
        return ItemAreaUpgrade.isUpgrade(this.getAreaUpgrade(), AreaUpgrade.CRAFTER);
    }

    private boolean hasVoid() {
        return ItemAreaUpgrade.isUpgrade(this.getAreaUpgrade(), AreaUpgrade.VOID);
    }

    private ItemStack getAreaUpgrade() {
        return this.gui.inv.getAreaUpgrade(this.gui.selectedArea, this.gui.upgradeIndex);
    }
}

