/*
 * Decompiled with CFR 0.152.
 */
package cubex2.advInv.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.opengl.GL11;

public class ScaledFontRenderer {
    private final FontRenderer font;
    public float scale = 1.0f;
    public static ScaledFontRenderer HALF = new ScaledFontRenderer(FMLClientHandler.instance().getClient().field_71466_p, 0.5f);
    public static ScaledFontRenderer ONE = new ScaledFontRenderer(FMLClientHandler.instance().getClient().field_71466_p, 1.0f);

    public ScaledFontRenderer(FontRenderer font) {
        this.font = font;
    }

    public ScaledFontRenderer(FontRenderer font, float scale) {
        this.font = font;
        this.scale = scale;
    }

    public void drawString(String s, int x, int y, int color) {
        this.drawString(s, x, y, 0, 0, color);
    }

    public void drawString(String s, int x, int y, int unscaledX, int unscaledY, int color) {
        float rx = (float)x / this.scale - (float)((int)((float)x / this.scale));
        float ry = (float)y / this.scale - (float)((int)((float)y / this.scale));
        GL11.glPushMatrix();
        GL11.glScalef((float)this.scale, (float)this.scale, (float)1.0f);
        GL11.glTranslatef((float)rx, (float)ry, (float)0.0f);
        this.font.func_78276_b(s, (int)((float)x / this.scale) + unscaledX, (int)((float)y / this.scale) + unscaledY, color);
        GL11.glScalef((float)(1.0f / this.scale), (float)(1.0f / this.scale), (float)1.0f);
        GL11.glPopMatrix();
    }

    public int getStringWidth(String s) {
        return (int)((float)this.font.func_78256_a(s) * this.scale);
    }

    public int getCharWidth(char c) {
        return (int)((float)this.font.func_78263_a(c) * this.scale);
    }

    public String trimStringToWidth(String s, int width) {
        return this.font.func_78269_a(s, (int)((float)width / this.scale));
    }

    public int getFontHeight() {
        return (int)((float)this.font.field_78288_b * this.scale);
    }

    public String[] splitToWidth(String s, int trimWidth) {
        if (this.getStringWidth(s) > trimWidth) {
            int width;
            String s1 = s;
            ArrayList list = Lists.newArrayList();
            while ((width = this.getStringWidth(s1)) > trimWidth) {
                int spaceIndex;
                String s2 = this.trimStringToWidth(s1, trimWidth);
                String remains = s1.substring(s2.length());
                if (remains.length() > 0 && (spaceIndex = s2.lastIndexOf(" ")) >= 0 && this.getStringWidth(s1.substring(0, spaceIndex)) > 0) {
                    s2 = s1.substring(0, spaceIndex);
                    remains = s1.substring(spaceIndex);
                }
                list.add(s2);
                s1 = remains;
            }
            list.add(s1);
            return list.toArray(new String[list.size()]);
        }
        return new String[]{s};
    }
}

