/*
 * Decompiled with CFR 0.152.
 */
package cubex2.advInv.gui.control;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraftforge.fml.client.FMLClientHandler;

public abstract class Control
extends Gui {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    public boolean enabled = true;
    public boolean visible = true;
    protected final Control parent;
    protected final List<Control> children = Lists.newArrayList();
    protected final Minecraft mc;

    public Control(int xOffset, int yOffset, int width, int height, Control parent) {
        if (parent == null) {
            this.x = xOffset;
            this.y = yOffset;
        } else {
            this.x = parent.x + xOffset;
            this.y = parent.y + yOffset;
        }
        this.width = width;
        this.height = height;
        this.parent = parent;
        this.mc = FMLClientHandler.instance().getClient();
    }

    public void draw(int mouseX, int mouseY) {
        for (Control c : this.children) {
            if (!c.visible) continue;
            c.draw(mouseX, mouseY);
        }
    }

    public void drawForeground(int mouseX, int mouseY) {
        for (Control c : this.children) {
            if (!c.visible) continue;
            c.drawForeground(mouseX, mouseY);
        }
    }

    public void mouseClicked(int mouseX, int mouseY, int button) {
        for (Control c : this.children) {
            if (!c.enabled || !c.visible || !c.isMouseOverControl(mouseX, mouseY)) continue;
            c.mouseClicked(mouseX, mouseY, button);
            this.controlClicked(c, mouseX, mouseY, button);
        }
    }

    protected void controlClicked(Control c, int mouseX, int mouseY, int button) {
    }

    public boolean isMouseOverControl(int mouseX, int mouseY) {
        return mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
    }
}

