/*
 * Decompiled with CFR 0.152.
 */
package cubex2.advInv.gui.control;

import com.google.common.collect.Lists;
import cubex2.advInv.gui.GuiAdvInv;
import cubex2.advInv.gui.control.Control;
import cubex2.advInv.lib.Textures;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import org.lwjgl.opengl.GL11;

public class OptionBox
extends Control {
    private final GuiAdvInv gui;
    private List<Option> options = Lists.newArrayList();
    private int selectedOption = -1;

    public OptionBox(int xOffset, int yOffset, Control parent, GuiAdvInv gui) {
        super(xOffset, yOffset, 16, 16, parent);
        this.gui = gui;
    }

    public void addOption(String id, String desc, String tex) {
        this.options.add(new Option(tex, id, desc));
        if (this.selectedOption == -1) {
            this.selectedOption = 0;
        }
    }

    public void setSelectedOption(String id) {
        for (int i = 0; i < this.options.size(); ++i) {
            Option option = this.options.get(i);
            if (!option.id.equals(id)) continue;
            this.selectedOption = i;
        }
    }

    public String getSelectedOption() {
        return this.options.get(this.selectedOption).id;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int button) {
        if (button == 0 && this.enabled && this.visible) {
            this.gui.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            if (this.options.size() > 0) {
                this.selectedOption = (this.selectedOption + 1) % this.options.size();
            }
        }
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Textures.GUI_EXTRA.drawPart("ob_bg", this.x, this.y);
        if (this.selectedOption == -1) {
            return;
        }
        Option option = this.options.get(this.selectedOption);
        Textures.GUI_EXTRA.drawPart(option.tex, this.x, this.y);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        if (this.selectedOption == -1) {
            return;
        }
        if (this.isMouseOverControl(mouseX, mouseY)) {
            this.gui.drawToolTip(this.options.get(this.selectedOption).desc.split("\n"), mouseX, mouseY, this.gui.field_146297_k.field_71466_p);
        }
    }

    private static class Option {
        private String tex;
        private String id;
        private String desc;

        public Option(String tex, String id, String desc) {
            this.tex = tex;
            this.id = id;
            this.desc = desc;
        }
    }
}

