/*
 * Decompiled with CFR 0.152.
 */
package cubex2.advInv.handler;

import com.google.common.collect.Lists;
import cubex2.advInv.Util;
import cubex2.advInv.data.ExtendedPlayerInv;
import cubex2.advInv.item.AreaUpgrade;
import cubex2.advInv.item.ItemAreaUpgrade;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EventHandler {
    private int tickCounter = 0;

    @SubscribeEvent
    public void onEntityConstructing(AttachCapabilitiesEvent event) {
        if (event.getObject() instanceof EntityPlayer && !event.getCapabilities().containsKey(ExtendedPlayerInv.PROPS_NAME)) {
            event.addCapability(ExtendedPlayerInv.PROPS_NAME, (ICapabilityProvider)new ExtendedPlayerInv((EntityPlayer)event.getObject()));
        }
    }

    @SubscribeEvent
    public void onPickup(EntityItemPickupEvent event) {
        EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
        ItemStack stack = event.getItem().func_92059_d().func_77946_l();
        stack.func_190920_e(1);
        NonNullList stacks = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
        stacks.set(0, (Object)stack);
        if (Util.doStacksFitInInventory((NonNullList<ItemStack>)stacks, player)) {
            return;
        }
        ExtendedPlayerInv inv = ExtendedPlayerInv.get((EntityPlayer)player);
        if (inv.addItemStackToInventory(event.getItem().func_92059_d())) {
            event.getItem().func_70106_y();
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.field_70170_p.field_72995_K) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter % 5 != 0) {
            return;
        }
        this.tickCounter = 0;
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        ExtendedPlayerInv inv = ExtendedPlayerInv.get((EntityPlayer)player);
        ArrayList collectors = Lists.newArrayList();
        for (int i = 0; i < 6; ++i) {
            Object collector = inv.getUpgrade(i, AreaUpgrade.COLLECTOR);
            if (collector.func_190926_b()) continue;
            collectors.add(new CollectorData(i, ItemAreaUpgrade.getPriority(collector), (ItemStack)collector));
        }
        Collections.sort(collectors);
        for (Object collector : collectors) {
            this.doCollectorWork(collector.stack, inv, player, collector.area);
        }
        for (int i = 0; i < 6; ++i) {
            ItemStack voider;
            ItemStack provider = inv.getUpgrade(i, AreaUpgrade.PROVIDER);
            if (!provider.func_190926_b()) {
                this.doProviderWork(provider, inv, (EntityPlayer)player, i);
            }
            if ((voider = inv.getUpgrade(i, AreaUpgrade.VOID)).func_190926_b()) continue;
        }
    }

    private void doCollectorWork(ItemStack collector, ExtendedPlayerInv inv, EntityPlayerMP player, int area) {
        for (int invSlot = 0; invSlot < 36; ++invSlot) {
            ItemStack invStack = player.field_71071_by.func_70301_a(invSlot);
            if (invStack.func_190926_b()) continue;
            boolean collected = false;
            for (int areaSlot = 0; areaSlot < 9; ++areaSlot) {
                if (!inv.canPutInArea(area, areaSlot, invStack)) continue;
                ItemStack areaStack = inv.getStack(area, areaSlot);
                if (areaStack.func_190926_b()) {
                    ItemStack stack = invStack.func_77946_l();
                    stack.func_190920_e(1);
                    inv.setStack(area, areaSlot, stack);
                    invStack.func_190918_g(1);
                    if (invStack.func_190916_E() <= 0) {
                        player.field_71071_by.func_70299_a(invSlot, ItemStack.field_190927_a);
                    }
                    collected = true;
                    break;
                }
                if (areaStack.func_77984_f() || areaStack.func_190916_E() >= areaStack.func_77976_d() || !areaStack.func_77969_a(invStack)) continue;
                invStack.func_190918_g(1);
                areaStack.func_190917_f(1);
                if (invStack.func_190916_E() <= 0) {
                    player.field_71071_by.func_70299_a(invSlot, ItemStack.field_190927_a);
                }
                collected = true;
                break;
            }
            if (!collected) continue;
            inv.func_70296_d();
            player.field_71071_by.func_70296_d();
            break;
        }
    }

    private void doProviderWork(ItemStack provider, ExtendedPlayerInv inv, EntityPlayer player, int area) {
        boolean consume = ItemAreaUpgrade.getConsume(provider);
        for (int areaSlot = 0; areaSlot < 9; ++areaSlot) {
            ItemStack stack = inv.getStack(area, areaSlot);
            if (stack.func_190926_b() || !consume && stack.func_190916_E() == 1) continue;
            boolean provided = false;
            for (int hbSlot = 0; hbSlot < 9; ++hbSlot) {
                ItemStack hbStack = player.field_71071_by.func_70301_a(hbSlot);
                if (hbStack.func_190926_b() || hbStack.func_77984_f() || hbStack.func_190916_E() == hbStack.func_77976_d() || !hbStack.func_77969_a(stack)) continue;
                hbStack.func_190917_f(1);
                stack.func_190918_g(1);
                if (stack.func_190916_E() <= 0) {
                    inv.setStack(area, areaSlot, ItemStack.field_190927_a);
                }
                inv.func_70296_d();
                player.field_71071_by.func_70296_d();
                provided = true;
                break;
            }
            if (provided) break;
        }
    }

    private void doVoidWork(ItemStack voider, ExtendedPlayerInv inv, EntityPlayer player, int area) {
        NonNullList<ItemStack> voidItems = ItemAreaUpgrade.getVoidItems(voider);
        for (int areaSlot = 0; areaSlot < 9; ++areaSlot) {
            ItemStack stack = inv.getStack(area, areaSlot);
            if (stack.func_190926_b()) continue;
            for (ItemStack filter : voidItems) {
                if (filter.func_190926_b() || !filter.func_77969_a(stack)) continue;
                inv.setStack(area, areaSlot, ItemStack.field_190927_a);
                inv.func_70296_d();
                return;
            }
        }
    }

    @SubscribeEvent
    public void onLivingDrops(PlayerDropsEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        ExtendedPlayerInv inv = ExtendedPlayerInv.get(player);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_190916_E() == 0) continue;
            EntityItem ei = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, stack.func_77946_l());
            ei.func_174867_a(40);
            float f1 = player.field_70170_p.field_73012_v.nextFloat() * 0.5f;
            float f2 = player.field_70170_p.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            ei.field_70159_w = -MathHelper.func_76126_a((float)f2) * f1;
            ei.field_70179_y = MathHelper.func_76134_b((float)f2) * f1;
            ei.field_70181_x = 0.2f;
            event.getDrops().add(ei);
            inv.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (!event.isWasDeath() || player.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            ExtendedPlayerInv old = ExtendedPlayerInv.get(event.getOriginal());
            ExtendedPlayerInv _new = ExtendedPlayerInv.get(event.getEntityPlayer());
            _new.copyInventory(old);
        }
    }

    private static class CollectorData
    implements Comparable<CollectorData> {
        int area;
        int priority;
        ItemStack stack;

        public CollectorData(int area, int priority, ItemStack stack) {
            this.area = area;
            this.priority = priority;
            this.stack = stack;
        }

        @Override
        public int compareTo(CollectorData o) {
            return o.priority - this.priority;
        }
    }
}

