/*
 * Decompiled with CFR 0.152.
 */
package usertravis.chambers;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import usertravis.chambers.Chamber;
import usertravis.chambers.Init;
import usertravis.chambers.Main;
import usertravis.chambers.Util;

public class ChamberBlock
extends Block {
    public String[] tip;
    public String mod;
    public String modName;
    public int gui;

    public ChamberBlock(Chamber chamber) {
        super(Material.field_151573_f);
        this.mod = chamber.modid;
        this.modName = chamber.modname;
        this.gui = chamber.gui;
        this.tip = chamber.tooltip;
        this.func_149647_a(Main.TAB_CHAMBERS);
        this.func_149663_c(chamber.registryname);
        this.setRegistryName(chamber.registryname);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b());
        Init.BLOCKS.add(this);
        Init.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(chamber.registryname));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (Loader.isModLoaded((String)this.mod)) {
            if (this.tip != null) {
                for (String s : this.tip) {
                    tooltip.add(s);
                }
            }
        } else {
            tooltip.add(Util.getNot(this.modName));
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (world.func_175625_s(pos) != null) {
                player.openGui((Object)Main.instance, this.gui, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        IItemHandler handler = (IItemHandler)worldIn.func_175625_s(pos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack itemstack = handler.getStackInSlot(i);
            if (itemstack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemstack);
        }
        super.func_180663_b(worldIn, pos, state);
    }
}

