/*
 * Decompiled with CFR 0.152.
 */
package usertravis.chambers.alchemy;

import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.power.DefaultEmberCapability;
import usertravis.chambers.Reference;
import usertravis.chambers.Util;
import usertravis.chambers.alchemy.RecipesAlchemyChamber;

public class TileEntityAlchemyChamber
extends TileEntity
implements ITickable,
IExtraCapabilityInformation {
    public IEmberCapability capability = new DefaultEmberCapability(){

        public void onContentsChanged() {
            TileEntityAlchemyChamber.this.func_70296_d();
        }

        public boolean acceptsVolatile() {
            return true;
        }
    };
    public ItemStackHandler handler = new ItemStackHandler(8){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!Util.ERloaded) {
                return stack;
            }
            if (slot < 5 && stack.func_77969_a(new ItemStack(Item.func_111206_d((String)"embers:dust_ash")))) {
                return stack;
            }
            switch (slot) {
                case 6: 
                case 7: {
                    return stack;
                }
                case 5: {
                    if (stack.func_77969_a(new ItemStack(Item.func_111206_d((String)"embers:dust_ash")))) break;
                    return stack;
                }
                case 0: {
                    if (RecipesAlchemyChamber.isInput(stack)) break;
                    return stack;
                }
                default: {
                    if (RecipesAlchemyChamber.isModifier(stack)) break;
                    return stack;
                }
            }
            return super.insertItem(slot, stack, simulate);
        }

        protected void onContentsChanged(int slot) {
            TileEntityAlchemyChamber.this.func_70296_d();
        }
    };
    private String customName;
    public int cookTime = 0;
    public int progress = 0;
    public int internalAsh = 0;
    public static final int MAX_ASH = 8192;
    public static final int MAXCOOK = 100;
    public static final int EMBER_USAGE = 400;

    public TileEntityAlchemyChamber() {
        this.onLoad();
        this.capability.setEmberCapacity(2000.0);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handler;
        }
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("Inventory", (NBTBase)this.handler.serializeNBT());
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("Ash", this.internalAsh);
        this.capability.writeToNBT(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.handler.deserializeNBT(compound.func_74775_l("Inventory"));
        this.capability.readFromNBT(compound);
        this.cookTime = compound.func_74762_e("CookTime");
        this.internalAsh = compound.func_74762_e("Ash");
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && Util.ERloaded) {
            this.doAsh();
            LinkedHashMap<ItemStack, Integer> inputIngredients = new LinkedHashMap<ItemStack, Integer>();
            for (int x = 0; x < 4; ++x) {
                if (this.handler.getStackInSlot(x + 1).func_190926_b()) continue;
                inputIngredients.put(this.handler.getStackInSlot(x + 1), this.handler.getStackInSlot(x + 1).func_190916_E());
            }
            Object[] result = RecipesAlchemyChamber.getRecipe(this.handler.getStackInSlot(0), inputIngredients);
            ItemStack output = (ItemStack)result[0];
            int amt = (Integer)result[1];
            boolean centerAsh = (Boolean)result[2];
            if (output != null && this.internalAsh + this.handler.getStackInSlot(6).func_190916_E() > amt && Util.outFree(this.handler.getStackInSlot(7), output) && (this.cookTime > 0 || this.capability.getEmber() >= 400.0)) {
                if (this.cookTime == 0) {
                    this.capability.removeAmount(400.0, true);
                }
                if (this.cookTime >= 100) {
                    this.cookTime = 0;
                    if (!centerAsh) {
                        this.handler.getStackInSlot(0).func_190918_g(1);
                    }
                    for (int x = 0; x < 4; ++x) {
                        ItemStack mod = this.handler.getStackInSlot(x + 1);
                        if (mod.func_190926_b()) continue;
                        mod.func_190918_g(mod.func_190916_E() - inputIngredients.get(mod));
                    }
                    if (amt > this.internalAsh) {
                        this.internalAsh = 0;
                        this.handler.getStackInSlot(6).func_190920_e(this.internalAsh + this.handler.getStackInSlot(6).func_190916_E() - amt);
                    } else {
                        this.internalAsh -= amt;
                    }
                    if (this.handler.getStackInSlot(7).func_190926_b()) {
                        this.handler.setStackInSlot(7, output);
                    } else {
                        this.handler.getStackInSlot(7).func_190917_f(output.func_190916_E());
                    }
                } else {
                    ++this.cookTime;
                }
                this.func_70296_d();
            } else {
                this.cookTime = 0;
            }
            this.progress = this.cookTime * 100 / 100;
        }
    }

    private void doAsh() {
        int toDo;
        boolean dirty = false;
        ItemStack input = this.handler.getStackInSlot(5);
        ItemStack output = this.handler.getStackInSlot(6);
        if (output.func_190916_E() < 64 && this.internalAsh > 0) {
            toDo = Math.min(this.internalAsh, 64 - output.func_190916_E());
            if (output.func_190926_b()) {
                this.handler.setStackInSlot(6, new ItemStack(Item.func_111206_d((String)"embers:dust_ash"), toDo));
            } else {
                output.func_190917_f(toDo);
            }
            this.internalAsh -= toDo;
            dirty = true;
        }
        if (this.internalAsh < 8128 && !input.func_190926_b()) {
            toDo = Math.min(8128 - this.internalAsh, input.func_190916_E());
            input.func_190918_g(toDo);
            this.internalAsh += toDo;
            dirty = true;
        }
        if (dirty) {
            this.func_70296_d();
        }
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(Util.getDisp(Reference.ALCHEMY), new Object[0]);
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.progress;
            }
            case 1: {
                return (int)this.capability.getEmber();
            }
            case 2: {
                return this.internalAsh;
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.progress = value;
                break;
            }
            case 1: {
                this.capability.setEmber((double)value);
                break;
            }
            case 2: {
                this.internalAsh = value;
            }
        }
    }

    public boolean hasCapabilityDescription(Capability<?> capability) {
        return true;
    }

    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability((IExtraCapabilityInformation.EnumIOType)IExtraCapabilityInformation.EnumIOType.BOTH, (String)"embers.tooltip.goggles.item", null));
        } else if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability((IExtraCapabilityInformation.EnumIOType)IExtraCapabilityInformation.EnumIOType.INPUT, (String)"embers.tooltip.goggles.ember", null));
        }
    }
}

