/*
 * Decompiled with CFR 0.152.
 */
package usertravis.chambers.anvil;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import usertravis.chambers.Reference;
import usertravis.chambers.Util;

public class TileEntitySoulAnvilChamber
extends TileEntity
implements ITickable {
    public ItemStackHandler handler = new ItemStackHandler(2){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return Util.Wootloaded && slot == 0 && Util.isSoul(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }

        protected void onContentsChanged(int slot) {
            TileEntitySoulAnvilChamber.this.func_70296_d();
        }
    };
    private String customName;
    public int progress = 0;
    public int cookTime = 0;
    public static final int cookTimeMax = Util.Wootloaded ? 20 : 1;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("Inventory", (NBTBase)this.handler.serializeNBT());
        compound.func_74768_a("CookTime", this.cookTime);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.handler.deserializeNBT(compound.func_74775_l("Inventory"));
        this.cookTime = compound.func_74762_e("CookTime");
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && Util.Wootloaded) {
            if (!this.handler.getStackInSlot(0).func_190926_b() && this.handler.getStackInSlot(1).func_190916_E() <= 61) {
                if (this.cookTime >= 20) {
                    this.cookTime = 0;
                    this.handler.getStackInSlot(0).func_190918_g(1);
                    if (!this.handler.getStackInSlot(1).func_190926_b()) {
                        this.handler.getStackInSlot(1).func_190917_f(3);
                    } else {
                        this.handler.setStackInSlot(1, new ItemStack(Item.func_111206_d((String)"woot:soulsanddust"), 3));
                    }
                } else {
                    ++this.cookTime;
                    this.func_70296_d();
                }
            } else {
                this.cookTime = 0;
            }
        }
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(Util.getDisp(Reference.SOUL_ANVIL), new Object[0]);
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public int getField(int id) {
        return cookTimeMax == 1 ? 0 : this.cookTime * 100 / 20;
    }

    public void setField(int id, int value) {
        this.progress = value;
    }
}

