/*
 * Decompiled with CFR 0.152.
 */
package usertravis.chambers.atom;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import usertravis.chambers.CustomEnergyStorage;
import usertravis.chambers.Reference;
import usertravis.chambers.Util;
import usertravis.chambers.atom.RecipesAtomChamber;

public class TileEntityAtomChamber
extends TileEntity
implements ITickable {
    private int power = Util.AAloaded ? RecipesAtomChamber.getPower() : 300000;
    private int recieve = MathHelper.func_76123_f((float)((float)this.power * 0.016666f));
    private CustomEnergyStorage storage = new CustomEnergyStorage(this.power, this.recieve * 2, 0);
    private int slotCount = 3;
    public ItemStackHandler handler = new ItemStackHandler(this.slotCount){

        public int getSlotLimit(int slot) {
            switch (slot) {
                case 0: 
                case 1: {
                    return Util.getLensType(TileEntityAtomChamber.this.handler.getStackInSlot(2)) == Util.LensType.DISENCHANTING ? 1 : 64;
                }
            }
            return 64;
        }

        protected boolean canInsert(ItemStack stack, int slot) {
            if (Util.AAloaded) {
                switch (slot) {
                    case 0: {
                        switch (Util.getLensType(TileEntityAtomChamber.this.handler.getStackInSlot(2))) {
                            case DEFAULT: {
                                return RecipesAtomChamber.isPossibleInput(stack);
                            }
                            case DISENCHANTING: {
                                return Util.isEnchantedNotBook(stack);
                            }
                            case MINING: {
                                return Util.type(stack) != -1;
                            }
                            case COLOR: {
                                return !RecipesAtomChamber.tryConvert(stack.func_77946_l()).func_190926_b();
                            }
                        }
                    }
                    case 1: {
                        return Util.getLensType(TileEntityAtomChamber.this.handler.getStackInSlot(2)) == Util.LensType.DISENCHANTING && Util.isBooks(stack);
                    }
                    case 2: {
                        return Util.getLensType(stack) != Util.LensType.DEFAULT;
                    }
                }
            }
            return false;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.canInsert(stack, slot)) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        protected void onContentsChanged(int slot) {
            TileEntityAtomChamber.this.func_70296_d();
        }
    };
    private String customName;
    public int progress = 0;
    public int cookTime = 0;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handler;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.storage);
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("Inventory", (NBTBase)this.handler.serializeNBT());
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("Energy", this.storage.get());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.handler.deserializeNBT(compound.func_74775_l("Inventory"));
        if (this.handler.getSlots() < this.slotCount) {
            this.handler.setSize(this.slotCount);
        }
        this.storage.set(compound.func_74762_e("Energy"));
        if (this.storage.get() > this.power) {
            this.storage.set(this.power);
        }
        this.cookTime = compound.func_74762_e("CookTime");
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && Util.AAloaded) {
            if (this.cookTime < 10) {
                ++this.cookTime;
                this.func_70296_d();
            } else {
                boolean isDis;
                Object[] result = RecipesAtomChamber.getRecipe(this.handler.getStackInSlot(0), this.handler.getStackInSlot(1), this.handler.getStackInSlot(2), this.func_145831_w());
                int energyUse = (Integer)result[1] + RecipesAtomChamber.getEnergyUse();
                if (energyUse > this.storage.get()) {
                    this.progress = -1;
                    if (energyUse > this.power) {
                        this.progress = -2;
                    }
                    return;
                }
                boolean bl = isDis = Util.getLensType(this.handler.getStackInSlot(2)) == Util.LensType.DISENCHANTING;
                if (result[0] != null && (this.handler.getStackInSlot(1).func_190926_b() || isDis || this.handler.getStackInSlot(1).func_190916_E() + ((ItemStack)result[0]).func_190916_E() <= 64 && this.handler.getStackInSlot(1).func_77969_a((ItemStack)result[0]))) {
                    if (isDis) {
                        if (this.storage.get() >= energyUse) {
                            this.cookTime = 0;
                            this.storage.sub(energyUse);
                            this.handler.setStackInSlot(0, (ItemStack)result[2]);
                            this.handler.setStackInSlot(1, (ItemStack)result[0]);
                        }
                        this.progress = this.cookTime * 100 / 10;
                        return;
                    }
                    int tofire = Util.getLensType(this.handler.getStackInSlot(2)) == Util.LensType.MINING ? 1 : this.handler.getStackInSlot(0).func_190916_E();
                    for (int x = 0; x < tofire && this.storage.get() >= energyUse && this.handler.getStackInSlot(1).func_190916_E() + ((ItemStack)result[0]).func_190916_E() <= 64; ++x) {
                        this.storage.sub(energyUse);
                        this.handler.getStackInSlot(0).func_190918_g(1);
                        if (!this.handler.getStackInSlot(1).func_190926_b()) {
                            this.handler.getStackInSlot(1).func_190917_f(((ItemStack)result[0]).func_190916_E());
                            continue;
                        }
                        this.handler.setStackInSlot(1, ((ItemStack)result[0]).func_77946_l());
                    }
                    this.cookTime = 0;
                    this.func_70296_d();
                }
            }
            this.progress = this.cookTime * 100 / 10;
        }
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(Util.getDisp(Reference.ATOM), new Object[0]);
    }

    public int getEnergyStored(int id) {
        switch (id) {
            case 1: {
                return this.storage.get() % 10000;
            }
            case 2: {
                return this.storage.get() / 10000 % 10000;
            }
            case 3: {
                return this.storage.get() / 100000000;
            }
        }
        return 0;
    }

    public void setEnergyStored(int id, int value) {
        switch (id) {
            case 1: {
                this.storage.set(this.storage.get() / 10000 * 10000 + value);
                break;
            }
            case 2: {
                this.storage.set(this.storage.get() / 100000000 * 100000000 + value * 10000 + this.storage.get() % 10000);
                break;
            }
            case 3: {
                this.storage.set(value * 100000000 + this.storage.get() % 100000000);
            }
        }
    }

    public int getMaxEnergyStored() {
        return this.storage.getMaxEnergyStored();
    }

    public int getAllEnergyStored() {
        return this.storage.get();
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.progress;
            }
            case 1: {
                return this.getEnergyStored(id);
            }
            case 2: {
                return this.getEnergyStored(id);
            }
            case 3: {
                return this.getEnergyStored(id);
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.progress = value;
                break;
            }
            case 1: {
                this.setEnergyStored(id, value);
                break;
            }
            case 2: {
                this.setEnergyStored(id, value);
                break;
            }
            case 3: {
                this.setEnergyStored(id, value);
            }
        }
    }
}

