/*
 * Decompiled with CFR 0.152.
 */
package usertravis.chambers.compact;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import usertravis.chambers.Recipes;
import usertravis.chambers.Reference;
import usertravis.chambers.Util;

public class TileEntityBigCompactChamber
extends TileEntity
implements ITickable {
    private static Item wall = Item.func_111206_d((String)"compactmachines3:wallbreakable");
    public static final Recipes[] r = new Recipes[]{new Recipes(new ItemStack(Item.func_111206_d((String)"compactmachines3:machine"), 1, 5), 600, new ItemStack(wall, 98), new ItemStack(Blocks.field_150475_bE), new ItemStack(Items.field_151079_bi)), new Recipes(new ItemStack(Item.func_111206_d((String)"compactmachines3:machine"), 1, 4), 560, new ItemStack(wall, 98), new ItemStack(Blocks.field_150484_ah), new ItemStack(Items.field_151079_bi)), new Recipes(new ItemStack(Item.func_111206_d((String)"compactmachines3:machine"), 1, 3), 520, new ItemStack(wall, 98), ItemStack.field_190927_a, new ItemStack(Items.field_151079_bi))};
    public ItemStackHandler handler = new ItemStackHandler(5){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (slot < 4 && Util.isInput(r, slot < 2 ? 0 : slot - 1, stack)) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        protected void onContentsChanged(int slot) {
            TileEntityBigCompactChamber.this.func_70296_d();
        }
    };
    private String customName;
    public int progress = 0;
    public int cookTime = 0;
    public int cookTimeMax = 1;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("Inventory", (NBTBase)this.handler.serializeNBT());
        compound.func_74768_a("CookTime", this.cookTime);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.handler.deserializeNBT(compound.func_74775_l("Inventory"));
        this.cookTime = compound.func_74762_e("CookTime");
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && Util.CMloaded) {
            int recipeID = -1;
            for (int x = 0; x < r.length; ++x) {
                if (!r[x].matches(new ItemStack(wall, this.handler.getStackInSlot(0).func_190916_E() + this.handler.getStackInSlot(1).func_190916_E()), this.handler.getStackInSlot(2), this.handler.getStackInSlot(3))) continue;
                recipeID = x;
                break;
            }
            if (recipeID != -1 && Util.outFree(this.handler.getStackInSlot(4), TileEntityBigCompactChamber.r[recipeID].output)) {
                this.cookTimeMax = TileEntityBigCompactChamber.r[recipeID].time;
                if (this.cookTime < this.cookTimeMax) {
                    this.cookTime += 10;
                    this.func_70296_d();
                } else {
                    this.cookTime = 0;
                    int wallsNeeded = TileEntityBigCompactChamber.r[recipeID].inputs.get(0).func_190916_E();
                    int one = Math.min(wallsNeeded, this.handler.getStackInSlot(1).func_190916_E());
                    this.handler.getStackInSlot(1).func_190918_g(one);
                    if (wallsNeeded - one > 0) {
                        this.handler.getStackInSlot(0).func_190918_g(wallsNeeded - one);
                    }
                    this.handler.getStackInSlot(2).func_190918_g(TileEntityBigCompactChamber.r[recipeID].inputs.get(1).func_190916_E());
                    this.handler.getStackInSlot(3).func_190918_g(TileEntityBigCompactChamber.r[recipeID].inputs.get(2).func_190916_E());
                    if (this.handler.getStackInSlot(4).func_190926_b()) {
                        this.handler.setStackInSlot(4, TileEntityBigCompactChamber.r[recipeID].output.func_77946_l());
                    } else {
                        this.handler.getStackInSlot(4).func_190917_f(TileEntityBigCompactChamber.r[recipeID].output.func_190916_E());
                    }
                }
            } else {
                this.cookTime = 0;
            }
        }
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(Util.getDisp(Reference.BIG_COMPACT), new Object[0]);
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public int getField(int id) {
        return this.cookTimeMax == 1 ? 0 : this.cookTime * 100 / this.cookTimeMax;
    }

    public void setField(int id, int value) {
        this.progress = value;
    }
}

