/*
 * Decompiled with CFR 0.152.
 */
package usertravis.chambers.compost;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import usertravis.chambers.Reference;
import usertravis.chambers.Util;
import usertravis.chambers.compost.RecipesCompostChamber;

public class TileEntityCompostChamber
extends TileEntity
implements ITickable {
    public ItemStackHandler handler = new ItemStackHandler(20){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (Util.AAloaded && slot < 10 && RecipesCompostChamber.isPossibleInput(stack)) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        protected void onContentsChanged(int slot) {
            TileEntityCompostChamber.this.func_70296_d();
        }
    };
    public int progress = 0;
    public int cookTime = 0;
    public static final int cookTimeMax = Util.AAloaded ? 300 : 1;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("Inventory", (NBTBase)this.handler.serializeNBT());
        compound.func_74768_a("CookTime", this.cookTime);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.handler.deserializeNBT(compound.func_74775_l("Inventory"));
        this.cookTime = compound.func_74762_e("CookTime");
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && Util.AAloaded) {
            block0: for (int currentSlot = 0; currentSlot < 10; ++currentSlot) {
                if (this.handler.getStackInSlot(currentSlot).func_190926_b()) continue;
                for (int openSlot = 10; openSlot < 20; ++openSlot) {
                    boolean empty = this.handler.getStackInSlot(openSlot).func_190926_b();
                    if (!empty && this.handler.getStackInSlot(openSlot).func_190916_E() >= 64) continue;
                    ItemStack output = RecipesCompostChamber.getRecipe(this.handler.getStackInSlot(currentSlot));
                    if (!empty && (this.handler.getStackInSlot(openSlot).func_190916_E() + output.func_190916_E() > 64 || !this.handler.getStackInSlot(openSlot).func_77969_a(output))) continue;
                    if (this.cookTime >= cookTimeMax) {
                        for (int nextSlot = openSlot; nextSlot < 20; ++nextSlot) {
                            for (int toCraft = this.handler.getStackInSlot(currentSlot).func_190916_E(); toCraft > 0 && ((empty = this.handler.getStackInSlot(nextSlot).func_190926_b()) || this.handler.getStackInSlot(nextSlot).func_190916_E() + output.func_190916_E() <= 64 && this.handler.getStackInSlot(nextSlot).func_77969_a(output)); --toCraft) {
                                if (empty) {
                                    this.handler.setStackInSlot(nextSlot, output.func_77946_l());
                                } else {
                                    this.handler.getStackInSlot(nextSlot).func_190917_f(output.func_190916_E());
                                }
                                this.handler.getStackInSlot(currentSlot).func_190918_g(1);
                                if (toCraft == 1) break block0;
                            }
                        }
                        break block0;
                    }
                    ++this.cookTime;
                    this.func_70296_d();
                    return;
                }
            }
            this.cookTime = 0;
        }
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(Util.getDisp(Reference.COMPOST), new Object[0]);
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public int getField(int id) {
        return cookTimeMax == 1 ? 0 : this.cookTime * 100 / cookTimeMax;
    }

    public void setField(int id, int value) {
        this.progress = value;
    }
}

