/*
 * Decompiled with CFR 0.152.
 */
package usertravis.chambers.empowerer;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import usertravis.chambers.CustomEnergyStorage;
import usertravis.chambers.Reference;
import usertravis.chambers.Util;
import usertravis.chambers.empowerer.RecipesEmpowererChamber;

public class TileEntityEmpowererChamber
extends TileEntity
implements ITickable {
    private CustomEnergyStorage storage = new CustomEnergyStorage(320000, 8000, 0);
    public ItemStackHandler handler = new ItemStackHandler(6){

        protected boolean canInsert(ItemStack stack, int slot) {
            if (!Util.AAloaded) {
                return false;
            }
            for (int x = 1; x <= slot; ++x) {
                boolean test = RecipesEmpowererChamber.isInput(stack, x);
                if (x != slot) {
                    if (!test) continue;
                    return false;
                }
                return test;
            }
            return RecipesEmpowererChamber.isInput(stack, 0);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.canInsert(stack, slot)) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        protected void onContentsChanged(int slot) {
            TileEntityEmpowererChamber.this.func_70296_d();
        }
    };
    private String customName;
    public int progress = 0;
    public int cookTime = 0;
    public int color;
    public Long recipeEnergy = 0L;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handler;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.storage);
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("Inventory", (NBTBase)this.handler.serializeNBT());
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74772_a("RecipeHoldingEnergy", this.recipeEnergy.longValue());
        compound.func_74768_a("Energy", this.storage.get());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.handler.deserializeNBT(compound.func_74775_l("Inventory"));
        this.storage.set(compound.func_74762_e("Energy"));
        this.cookTime = compound.func_74762_e("CookTime");
        this.recipeEnergy = compound.func_74763_f("RecipeHoldingEnergy");
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && Util.AAloaded) {
            ItemStack[] recipeTest = new ItemStack[]{this.handler.getStackInSlot(1).func_77946_l(), this.handler.getStackInSlot(2).func_77946_l(), this.handler.getStackInSlot(3).func_77946_l(), this.handler.getStackInSlot(4).func_77946_l()};
            int[] inputCounts = new int[]{recipeTest[0].func_190916_E(), recipeTest[1].func_190916_E(), recipeTest[2].func_190916_E()};
            int[] redir = new int[]{0, 0, 0};
            block0: for (int currentSlot = 4; currentSlot > 1; --currentSlot) {
                if (!this.handler.getStackInSlot(currentSlot).func_190926_b()) continue;
                for (int mergeSlot = currentSlot - 1; mergeSlot > 0; --mergeSlot) {
                    if (this.handler.getStackInSlot(mergeSlot).func_190926_b() || inputCounts[mergeSlot - 1] <= 1) continue;
                    redir[currentSlot - 2] = mergeSlot;
                    int n = mergeSlot - 1;
                    inputCounts[n] = inputCounts[n] - 1;
                    recipeTest[currentSlot - 1] = this.handler.getStackInSlot(mergeSlot).func_77946_l();
                    continue block0;
                }
            }
            Object[] result = RecipesEmpowererChamber.getRecipe(this.handler.getStackInSlot(0), recipeTest);
            int cookTimeMax = (Integer)result[1];
            long energyNeeded = (long)((Integer)result[2]).intValue() * 4L;
            this.color = (Integer)result[3];
            if (result[0] != null && (this.handler.getStackInSlot(5).func_190926_b() || this.handler.getStackInSlot(5).func_190916_E() + ((ItemStack)result[0]).func_190916_E() <= 64 && this.handler.getStackInSlot(5).func_77969_a((ItemStack)result[0]))) {
                if (this.recipeEnergy.compareTo(energyNeeded) < 0) {
                    int toStore = (int)Math.min(energyNeeded - this.recipeEnergy, (long)this.storage.get());
                    this.storage.sub(toStore);
                    this.recipeEnergy = this.recipeEnergy + (long)toStore;
                    this.func_70296_d();
                }
                if (this.cookTime < cookTimeMax) {
                    ++this.cookTime;
                    this.func_70296_d();
                } else if (this.recipeEnergy.compareTo(energyNeeded) >= 0) {
                    this.recipeEnergy = this.recipeEnergy - energyNeeded;
                    this.cookTime = 0;
                    this.handler.getStackInSlot(0).func_190918_g(1);
                    this.handler.getStackInSlot(1).func_190918_g(1);
                    for (int x = 0; x < 3; ++x) {
                        if (0 != redir[x]) {
                            this.handler.getStackInSlot(redir[x]).func_190918_g(1);
                            continue;
                        }
                        this.handler.getStackInSlot(x + 2).func_190918_g(1);
                    }
                    if (!this.handler.getStackInSlot(5).func_190926_b()) {
                        this.handler.getStackInSlot(5).func_190917_f(((ItemStack)result[0]).func_190916_E());
                    } else {
                        this.handler.setStackInSlot(5, ((ItemStack)result[0]).func_77946_l());
                    }
                }
            } else {
                this.cookTime = 0;
            }
            this.progress = Math.min(this.cookTime * 100 / cookTimeMax, (int)(this.recipeEnergy * 100L / energyNeeded));
        }
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(Util.getDisp(Reference.EMPOWERER), new Object[0]);
    }

    public int getEnergyStored(int id) {
        switch (id) {
            case 1: {
                return this.storage.get() % 10000;
            }
            case 2: {
                return this.storage.get() / 10000 % 10000;
            }
        }
        return 0;
    }

    public void setEnergyStored(int id, int value) {
        switch (id) {
            case 1: {
                this.storage.set(this.storage.get() / 10000 * 10000 + value);
                break;
            }
            case 2: {
                this.storage.set(value * 10000 + this.storage.get() % 10000);
            }
        }
    }

    public int getMaxEnergyStored() {
        return this.storage.getMaxEnergyStored();
    }

    public int getAllEnergyStored() {
        return this.storage.get();
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.progress;
            }
            case 1: {
                return this.getEnergyStored(id);
            }
            case 2: {
                return this.getEnergyStored(id);
            }
            case 3: {
                return this.color;
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.progress = value;
                break;
            }
            case 1: {
                this.setEnergyStored(id, value);
                break;
            }
            case 2: {
                this.setEnergyStored(id, value);
                break;
            }
            case 3: {
                this.color = value;
            }
        }
    }
}

