/*
 * Decompiled with CFR 0.152.
 */
package usertravis.chambers.enchant;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import usertravis.chambers.CustomEnergyStorage;
import usertravis.chambers.Recipes;
import usertravis.chambers.Reference;
import usertravis.chambers.Util;

public class TileEntityEnchantChamber
extends TileEntity
implements ITickable {
    public static final Recipes[] r = new Recipes[]{new Recipes(new ItemStack(Item.func_111206_d((String)"extrautils2:decorativesolidwood"), 1, 1), 1600, new ItemStack(Blocks.field_150342_X), new ItemStack(Items.field_151100_aR, 1, 4)), new Recipes(new ItemStack(Item.func_111206_d((String)"extrautils2:simpledecorative")), 600, new ItemStack(Blocks.field_150340_R), new ItemStack(Items.field_151100_aR, 9, 4)), new Recipes(new ItemStack(Item.func_111206_d((String)"extrautils2:ingredients"), 1, 12), 200, new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151100_aR, 1, 4)), new Recipes(new ItemStack(Item.func_111206_d((String)"extrautils2:simpledecorative"), 8, 2), 4800, new ItemStack(Blocks.field_150339_S, 8), new ItemStack(Items.field_151156_bN, 9)), new Recipes(new ItemStack(Item.func_111206_d((String)"extrautils2:ingredients"), 8, 17), 1600, new ItemStack(Items.field_151042_j, 8), new ItemStack(Items.field_151156_bN)), new Recipes(new ItemStack(Item.func_111206_d((String)"extrautils2:magicapple"), 16), 400, new ItemStack(Items.field_151034_e, 16), new ItemStack(Items.field_151100_aR, 1, 4))};
    private CustomEnergyStorage storage = new CustomEnergyStorage(100000, 100000, 0);
    public ItemStackHandler handler = new ItemStackHandler(4){

        protected boolean canInsert(ItemStack stack, int slot) {
            if (!Util.XUloaded) {
                return false;
            }
            switch (slot) {
                case 0: 
                case 1: {
                    return Util.isInput(r, slot, stack);
                }
                case 3: {
                    return Util.isOverclock(stack);
                }
            }
            return false;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.canInsert(stack, slot)) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        protected void onContentsChanged(int slot) {
            TileEntityEnchantChamber.this.func_70296_d();
        }
    };
    private String customName;
    public int progress = 0;
    public int cookTime = 0;
    public int energyUse = 0;
    public int cookTimeMax = 1;
    public static final int ENERGY = 40;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handler;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.storage);
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("Inventory", (NBTBase)this.handler.serializeNBT());
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("Energy", this.storage.get());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.handler.deserializeNBT(compound.func_74775_l("Inventory"));
        this.storage.set(compound.func_74762_e("Energy"));
        this.cookTime = compound.func_74762_e("CookTime");
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && Util.XUloaded) {
            int recipeID = -1;
            for (int x = 0; x < r.length; ++x) {
                if (!r[x].matches(this.handler.getStackInSlot(0), this.handler.getStackInSlot(1))) continue;
                recipeID = x;
                break;
            }
            if (recipeID != -1) {
                this.cookTimeMax = TileEntityEnchantChamber.r[recipeID].time;
                if (this.storage.get() >= 40 * this.cookTimeMax - this.cookTime * 40 && Util.outFree(this.handler.getStackInSlot(2), TileEntityEnchantChamber.r[recipeID].output)) {
                    if (this.cookTime >= this.cookTimeMax) {
                        this.reset();
                        this.handler.getStackInSlot(0).func_190918_g(TileEntityEnchantChamber.r[recipeID].inputs.get(0).func_190916_E());
                        this.handler.getStackInSlot(1).func_190918_g(TileEntityEnchantChamber.r[recipeID].inputs.get(1).func_190916_E());
                        if (this.handler.getStackInSlot(2).func_190926_b()) {
                            this.handler.setStackInSlot(2, TileEntityEnchantChamber.r[recipeID].output.func_77946_l());
                        } else {
                            this.handler.getStackInSlot(2).func_190917_f(TileEntityEnchantChamber.r[recipeID].output.func_190916_E());
                        }
                    } else {
                        int speed;
                        int n = speed = this.handler.getStackInSlot(3).func_190926_b() ? 1 : this.handler.getStackInSlot(3).func_190916_E() + 1;
                        if (speed > this.cookTimeMax - this.cookTime) {
                            speed = this.cookTimeMax - this.cookTime;
                        }
                        this.cookTime += speed;
                        this.energyUse = 40 * speed;
                        this.storage.sub(this.energyUse);
                        this.func_70296_d();
                    }
                } else {
                    this.reset();
                }
            } else {
                this.reset();
            }
        }
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(Util.getDisp(Reference.ENCHANT), new Object[0]);
    }

    private void reset() {
        this.cookTime = 0;
        this.energyUse = 0;
    }

    public int getEnergyStored(int id) {
        switch (id) {
            case 1: {
                return this.storage.get() % 10000;
            }
            case 2: {
                return this.storage.get() / 10000 % 10000;
            }
        }
        return 0;
    }

    public void setEnergyStored(int id, int value) {
        switch (id) {
            case 1: {
                this.storage.set(this.storage.get() / 10000 * 10000 + value);
                break;
            }
            case 2: {
                this.storage.set(value * 10000 + this.storage.get() % 10000);
            }
        }
    }

    public int getMaxEnergyStored() {
        return this.storage.getMaxEnergyStored();
    }

    public int getAllEnergyStored() {
        return this.storage.get();
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.cookTimeMax == 1 ? 0 : this.cookTime * 100 / this.cookTimeMax;
            }
            case 1: {
                return this.getEnergyStored(id);
            }
            case 2: {
                return this.getEnergyStored(id);
            }
            case 3: {
                return this.energyUse;
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.progress = value;
                break;
            }
            case 1: {
                this.setEnergyStored(id, value);
                break;
            }
            case 2: {
                this.setEnergyStored(id, value);
                break;
            }
            case 3: {
                this.energyUse = value;
            }
        }
    }
}

