/*
 * Decompiled with CFR 0.152.
 */
package usertravis.chambers.fluid;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import usertravis.chambers.Reference;
import usertravis.chambers.Util;

public class TileEntityFluidChamber
extends TileEntity
implements ITickable {
    protected FluidTank tank = new FluidTank(10000);
    private NonNullList<FluidTank> fluidInventory = NonNullList.func_191197_a((int)3, (Object)new FluidTank(10000));
    public ItemStackHandler handler = new ItemStackHandler(20){

        protected boolean canInsert(ItemStack stack, int slot) {
            if (!Util.AAloaded) {
                return false;
            }
            return false;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.canInsert(stack, slot)) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        protected void onContentsChanged(int slot) {
            TileEntityFluidChamber.this.func_70296_d();
        }
    };
    private String customName;
    public int progress = 0;
    public int cookTimeMax = 1;

    public TileEntityFluidChamber() {
        for (FluidTank tank : this.fluidInventory) {
            tank.setTileEntity((TileEntity)this);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handler;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.tank.writeToNBT(compound);
        compound.func_74782_a("Inventory", (NBTBase)this.handler.serializeNBT());
        compound.func_74768_a("Progress", this.progress);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tank.readFromNBT(compound);
        this.handler.deserializeNBT(compound.func_74775_l("Inventory"));
        this.progress = compound.func_74762_e("Progress");
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            // empty if block
        }
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(Util.getDisp(Reference.FLUID), new Object[0]);
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public int getField(int id) {
        return this.cookTimeMax == 1 ? 0 : this.progress * 100 / 300;
    }

    public void setField(int id, int value) {
        this.progress = value;
    }
}

