/*
 * Decompiled with CFR 0.152.
 */
package usertravis.chambers.fusion;

import com.brandon3055.draconicevolution.api.OreDictHelper;
import com.brandon3055.draconicevolution.api.fusioncrafting.FusionRecipeAPI;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class RecipesFusionChamber {
    public static Object[] getRecipe(ItemStack catalyst, LinkedHashMap<ItemStack, Integer> inputs) {
        ItemStack result = null;
        Long energyCost = 0L;
        int tier = 0;
        int injectorsNeeded = 0;
        int catCount = 1;
        block0: for (IFusionRecipe r : FusionRecipeAPI.getRecipes()) {
            if (!r.isRecipeCatalyst(catalyst)) continue;
            int recipeCatCount = r.getRecipeCatalyst().func_190916_E();
            if (recipeCatCount > 1) {
                if (catalyst.func_190916_E() < recipeCatCount) continue;
                catCount = recipeCatCount;
            }
            result = r.getRecipeOutput(catalyst);
            injectorsNeeded = r.getRecipeIngredients().size();
            energyCost = r.getIngredientEnergyCost() * (long)injectorsNeeded;
            tier = r.getRecipeTier();
            int x = 0;
            boolean isToolUpgradeRecipe = r.toString().startsWith("ToolUpgrade");
            for (Object i : r.getRecipeIngredients()) {
                ++x;
                ItemStack recipeInput = OreDictHelper.resolveObject(i);
                int recipeCount = recipeInput.func_190916_E();
                boolean ingredientUsed = false;
                for (Map.Entry<ItemStack, Integer> entry : inputs.entrySet()) {
                    ItemStack itemStack = entry.getKey();
                    int used = entry.getValue();
                    if (!recipeInput.func_77969_a(itemStack) || itemStack.func_190916_E() <= used || !isToolUpgradeRecipe && !ItemStack.func_77970_a((ItemStack)recipeInput, (ItemStack)itemStack)) continue;
                    int usingThisTime = Math.min(itemStack.func_190916_E() - used, recipeCount);
                    inputs.put(itemStack, usingThisTime + used);
                    if ((recipeCount -= usingThisTime) != 0) continue;
                    ingredientUsed = true;
                    break;
                }
                if (!ingredientUsed) {
                    for (Map.Entry<ItemStack, Integer> entry : inputs.entrySet()) {
                        inputs.put(entry.getKey(), 0);
                    }
                    result = null;
                    continue block0;
                }
                if (x != r.getRecipeIngredients().size()) continue;
                return new Object[]{result, energyCost, tier, catCount, injectorsNeeded};
            }
        }
        return new Object[]{null, null, null, null, null};
    }

    public static boolean isCatalyst(ItemStack stack) {
        for (IFusionRecipe r : FusionRecipeAPI.getRecipes()) {
            if (!r.isRecipeCatalyst(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIngredient(ItemStack stack) {
        for (IFusionRecipe r : FusionRecipeAPI.getRecipes()) {
            for (Object ingredient : r.getRecipeIngredients()) {
                ItemStack itemStack = OreDictHelper.resolveObject(ingredient);
                if (!stack.func_77969_a(itemStack)) continue;
                if (r.toString().startsWith("ToolUpgrade")) {
                    return true;
                }
                if (!ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemStack)) continue;
                return true;
            }
        }
        return false;
    }
}

