/*
 * Decompiled with CFR 0.152.
 */
package usertravis.chambers.fusion;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import scala.Int;
import usertravis.chambers.CustomEnergyStorage;
import usertravis.chambers.Reference;
import usertravis.chambers.Util;
import usertravis.chambers.fusion.RecipesFusionChamber;

public class TileEntityFusionChamber
extends TileEntity
implements ITickable {
    private CustomEnergyStorage storage = new CustomEnergyStorage(1000000000, Int.MaxValue(), 0);
    public ItemStackHandler handler = new ItemStackHandler(58){

        public int getSlotLimit(int slot) {
            switch (slot) {
                case 0: 
                case 1: {
                    return 64;
                }
                case 2: {
                    return 4;
                }
                case 3: {
                    return 54;
                }
            }
            return TileEntityFusionChamber.this.handler.getStackInSlot(3).func_190916_E() > slot - 4 ? 64 : 0;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!Util.DEloaded) {
                return stack;
            }
            switch (slot) {
                case 0: {
                    if (RecipesFusionChamber.isCatalyst(stack)) break;
                    return stack;
                }
                case 1: {
                    return stack;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (Util.isInject(stack)) break;
                    return stack;
                }
                default: {
                    if (RecipesFusionChamber.isIngredient(stack)) break;
                    return stack;
                }
            }
            return super.insertItem(slot, stack, simulate);
        }

        protected void onContentsChanged(int slot) {
            TileEntityFusionChamber.this.func_70296_d();
        }
    };
    private String customName;
    public int progress = 0;
    public int archive = 0;
    public int errorCode = 0;
    public static final long MAX_ENERGY = 10001000000000L;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.handler;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.storage);
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("Inventory", (NBTBase)this.handler.serializeNBT());
        compound.func_74768_a("Progress", this.progress);
        compound.func_74768_a("Archive", this.archive);
        compound.func_74768_a("Energy", this.storage.get());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.handler.deserializeNBT(compound.func_74775_l("Inventory"));
        this.storage.set(compound.func_74762_e("Energy"));
        this.progress = compound.func_74762_e("Progress");
        this.archive = compound.func_74762_e("Archive");
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && Util.DEloaded) {
            int archiveMax = 0;
            if (this.handler.getStackInSlot(2).func_190916_E() > 0) {
                archiveMax = (int)Math.pow(10.0, this.handler.getStackInSlot(2).func_190916_E());
                if (archiveMax == 1) {
                    archiveMax = 0;
                }
                if (this.storage.get() == this.storage.getMaxEnergyStored() && this.archive < archiveMax) {
                    this.storage.set(0);
                    ++this.archive;
                    this.func_70296_d();
                }
            }
            Object[] result = new Object[]{null, null, null, null, null};
            LinkedHashMap<ItemStack, Integer> inputIngredients = new LinkedHashMap<ItemStack, Integer>();
            if (!this.handler.getStackInSlot(0).func_190926_b()) {
                for (int x = 0; x < 54; ++x) {
                    if (this.handler.getStackInSlot(x + 4).func_190926_b()) continue;
                    inputIngredients.put(this.handler.getStackInSlot(x + 4), 0);
                }
                if (!inputIngredients.isEmpty()) {
                    result = RecipesFusionChamber.getRecipe(this.handler.getStackInSlot(0), inputIngredients);
                }
            }
            this.errorCode = 0;
            if (result[0] != null) {
                int ped = this.handler.getStackInSlot(3).func_77960_j();
                Long energyRequired = (long)((Long)result[1]);
                Long archiveTotal = (long)this.archive * 1000000000L;
                if (Math.max((long)archiveMax * 1000000000L, archiveTotal) + 1000000000L < energyRequired) {
                    this.errorCode = -3;
                }
                if ((Integer)result[4] > this.handler.getStackInSlot(3).func_190916_E()) {
                    this.errorCode = -5 - ((Integer)result[4] - this.handler.getStackInSlot(3).func_190916_E());
                }
                if ((Integer)result[4] > 54) {
                    this.errorCode = -4;
                }
                if (this.handler.getStackInSlot(3).func_190916_E() > 0 && (Integer)result[2] > ped) {
                    this.errorCode = -2;
                }
                if (energyRequired > 10001000000000L) {
                    this.errorCode = -1;
                }
                if (this.errorCode >= 0 || this.errorCode == -3) {
                    if (this.errorCode != -3) {
                        this.errorCode = ped - (Integer)result[2];
                    }
                    if (energyRequired > archiveTotal + (long)this.storage.get()) {
                        this.progress = 1 + (int)((archiveTotal + (long)this.storage.get()) * 100L / energyRequired);
                    } else {
                        if (this.progress < 101) {
                            this.progress = 101;
                        }
                        if (this.progress < 1101) {
                            if (this.handler.getStackInSlot(1).func_190926_b() || ((ItemStack)result[0]).func_77969_a(this.handler.getStackInSlot(1)) && ItemStack.func_77970_a((ItemStack)((ItemStack)result[0]), (ItemStack)this.handler.getStackInSlot(1)) && ((ItemStack)result[0]).func_190916_E() + this.handler.getStackInSlot(1).func_190916_E() <= this.handler.getStackInSlot(1).func_77976_d()) {
                                if (this.progress < 102) {
                                    ++this.progress;
                                }
                                this.progress += 2 + (ped - 3 == (Integer)result[2] ? 5 : (ped - 2 == (Integer)result[2] ? 3 : (ped - 1 == (Integer)result[2] ? 1 : 0)));
                                if (this.progress > 1102) {
                                    this.progress = 1102;
                                }
                            } else {
                                this.progress = 102;
                            }
                        } else {
                            if (energyRequired.compareTo(Long.valueOf(this.storage.get())) > 0) {
                                long remaining = archiveTotal + (long)this.storage.get() - energyRequired;
                                this.storage.set((int)(remaining % 1000000000L));
                                this.archive = (int)(remaining / 1000000000L);
                            } else {
                                this.storage.sub(energyRequired.intValue());
                            }
                            this.handler.getStackInSlot(0).func_190918_g(((Integer)result[3]).intValue());
                            for (Map.Entry<ItemStack, Integer> entry : inputIngredients.entrySet()) {
                                ItemStack itemStack = entry.getKey();
                                int amount = entry.getValue();
                                for (int x = 0; x < 54; ++x) {
                                    if (!this.handler.getStackInSlot(x + 4).equals(itemStack)) continue;
                                    this.handler.getStackInSlot(x + 4).func_190918_g(amount);
                                }
                            }
                            if (this.handler.getStackInSlot(1).func_190926_b()) {
                                this.handler.setStackInSlot(1, ((ItemStack)result[0]).func_77946_l());
                            } else {
                                this.handler.getStackInSlot(1).func_190917_f(((ItemStack)result[0]).func_190916_E());
                            }
                            this.progress = 0;
                        }
                        this.func_70296_d();
                    }
                } else {
                    this.progress = 0;
                }
            } else {
                this.progress = 0;
                this.errorCode = 0;
            }
        }
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(Util.getDisp(Reference.FUSION), new Object[0]);
    }

    public ITextComponent getDisplayName2() {
        return new TextComponentTranslation(Util.getDisp(Reference.FUSION) + "2", new Object[0]);
    }

    public int getEnergyStored(int id) {
        switch (id) {
            case 1: {
                return this.storage.get() % 10000;
            }
            case 2: {
                return this.storage.get() / 10000 % 10000;
            }
            case 3: {
                return this.storage.get() / 100000000;
            }
        }
        return 0;
    }

    public void setEnergyStored(int id, int value) {
        switch (id) {
            case 1: {
                this.storage.set(this.storage.get() / 10000 * 10000 + value);
                break;
            }
            case 2: {
                this.storage.set(this.storage.get() / 100000000 * 100000000 + value * 10000 + this.storage.get() % 10000);
                break;
            }
            case 3: {
                this.storage.set(value * 100000000 + this.storage.get() % 100000000);
            }
        }
    }

    public int getMaxEnergyStored() {
        return this.storage.getMaxEnergyStored();
    }

    public int getAllEnergyStored() {
        return this.storage.get();
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.progress;
            }
            case 1: {
                return this.getEnergyStored(id);
            }
            case 2: {
                return this.getEnergyStored(id);
            }
            case 3: {
                return this.getEnergyStored(id);
            }
            case 4: {
                return this.archive;
            }
            case 5: {
                return this.errorCode;
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.progress = value;
                break;
            }
            case 1: {
                this.setEnergyStored(id, value);
                break;
            }
            case 2: {
                this.setEnergyStored(id, value);
                break;
            }
            case 3: {
                this.setEnergyStored(id, value);
                break;
            }
            case 4: {
                this.archive = value;
                break;
            }
            case 5: {
                this.errorCode = value;
            }
        }
    }
}

