/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.sneakdevs.diamondeconomy;

import com.gmail.sneakdevs.diamondeconomy.DatabaseManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class DECommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"diamonds").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"top").then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)20)).executes(e -> {
            int amount = IntegerArgumentType.getInteger((CommandContext)e, (String)"amount");
            return DECommands.topCommand((CommandContext<class_2168>)e, amount);
        }))).executes(e -> DECommands.topCommand((CommandContext<class_2168>)e, 5)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"balance").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(e -> {
            class_3222 player = class_2186.method_9315((CommandContext)e, (String)"player");
            return DECommands.balanceCommand((CommandContext<class_2168>)e, player);
        }))).executes(e -> DECommands.balanceCommand((CommandContext<class_2168>)e, null)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"deposit").then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(e -> {
            int amount = IntegerArgumentType.getInteger((CommandContext)e, (String)"amount");
            return DECommands.depositCommand((CommandContext<class_2168>)e, amount);
        }))).executes(e -> DECommands.depositCommand((CommandContext<class_2168>)e, 0)))).then(class_2170.method_9247((String)"withdraw").then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(e -> {
            int amount = IntegerArgumentType.getInteger((CommandContext)e, (String)"amount");
            return DECommands.withdrawCommand((CommandContext<class_2168>)e, amount);
        })))).then(class_2170.method_9247((String)"send").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(e -> {
            class_3222 player = class_2186.method_9315((CommandContext)e, (String)"player");
            int amount = IntegerArgumentType.getInteger((CommandContext)e, (String)"amount");
            return DECommands.sendCommand((CommandContext<class_2168>)e, player, amount);
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"take").requires(permission -> permission.method_9259(4))).then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(e -> {
            int amount = IntegerArgumentType.getInteger((CommandContext)e, (String)"amount");
            return DECommands.takeCommand((CommandContext<class_2168>)e, class_2186.method_9312((CommandContext)e, (String)"players").stream().toList(), amount);
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"give").requires(permission -> permission.method_9259(4))).then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(e -> {
            int amount = IntegerArgumentType.getInteger((CommandContext)e, (String)"amount");
            return DECommands.giveCommand((CommandContext<class_2168>)e, class_2186.method_9312((CommandContext)e, (String)"players").stream().toList(), amount);
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(permission -> permission.method_9259(4))).then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(e -> {
            int amount = IntegerArgumentType.getInteger((CommandContext)e, (String)"amount");
            return DECommands.setCommand((CommandContext<class_2168>)e, class_2186.method_9312((CommandContext)e, (String)"players").stream().toList(), amount);
        })))));
    }

    private static int withdrawCommand(CommandContext<class_2168> ctx, int amount) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        DatabaseManager dm = new DatabaseManager();
        String uuid = player.method_5845();
        String name = player.method_5477().method_10851();
        if (dm.getBalance(uuid) >= amount) {
            DECommands.dropDiamonds(amount, player);
            dm.setBalance(uuid, name, dm.getBalance(uuid) - amount);
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585("Withdrew " + amount + " diamonds"), false);
            return 1;
        }
        ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585("You have less than " + amount + " diamonds"), false);
        return 1;
    }

    private static int depositCommand(CommandContext<class_2168> ctx, int amount) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        DatabaseManager dm = new DatabaseManager();
        int diamondCount = 0;
        int bal = dm.getBalance(player.method_5845());
        int newValue = bal + amount;
        if (newValue < Integer.MAX_VALUE && newValue >= 0) {
            for (int i = 0; i < 36; ++i) {
                if (player.method_31548().method_5438(i).method_7909().equals(class_1802.field_8477)) {
                    diamondCount += player.method_31548().method_5438(i).method_7947();
                    player.method_31548().method_5447(i, new class_1799((class_1935)class_1802.field_8162));
                    continue;
                }
                if (!player.method_31548().method_5438(i).method_7909().equals(class_1802.field_8603)) continue;
                diamondCount += player.method_31548().method_5438(i).method_7947() * 9;
                player.method_31548().method_5447(i, new class_1799((class_1935)class_1802.field_8162));
            }
            if (amount == 0) {
                newValue = bal + diamondCount;
                if (newValue < Integer.MAX_VALUE && newValue > 0) {
                    dm.setBalance(player.method_5845(), player.method_5477().method_10851(), diamondCount + bal);
                    ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585("Added " + diamondCount + " diamonds to your account"), false);
                    return 1;
                }
                DECommands.dropDiamonds(diamondCount, player);
                ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585("You do not have enough room in your account"), false);
                return 0;
            }
            if (amount > diamondCount) {
                DECommands.dropDiamonds(diamondCount, player);
                ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585("You do not have enough diamonds in your inventory"), false);
                return 0;
            }
            DECommands.dropDiamonds(diamondCount - amount, player);
            dm.setBalance(player.method_5845(), player.method_5477().method_10851(), amount + bal);
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585("Added " + amount + " diamonds to your account"), false);
            return 1;
        }
        ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585("You do not have enough room in your account"), false);
        return 0;
    }

    private static int takeCommand(CommandContext<class_2168> ctx, Collection<class_3222> players, int amount) {
        DatabaseManager dm = new DatabaseManager();
        players.forEach(player -> {
            if (amount > dm.getBalance(player.method_5845())) {
                dm.setBalance(player.method_5845(), player.method_5477().method_10851(), 0);
            } else {
                dm.setBalance(player.method_5845(), player.method_5477().method_10851(), dm.getBalance(player.method_5845()) - amount);
            }
        });
        ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585("Took " + Math.abs(amount) + " diamonds from " + players.size() + " players"), false);
        return players.size();
    }

    private static int giveCommand(CommandContext<class_2168> ctx, Collection<class_3222> players, int amount) {
        DatabaseManager dm = new DatabaseManager();
        players.forEach(player -> {
            int newValue = dm.getBalance(player.method_5845()) + amount;
            if (newValue < Integer.MAX_VALUE && newValue > 0) {
                dm.setBalance(player.method_5845(), player.method_5477().method_10851(), dm.getBalance(player.method_5845()) + amount);
                ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585("Gave " + players.size() + " players " + amount + " diamonds"), false);
            } else {
                ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585("That would go over the max value for " + player.method_5477().method_10851()), false);
            }
        });
        return players.size();
    }

    private static int setCommand(CommandContext<class_2168> ctx, Collection<class_3222> players, int amount) {
        DatabaseManager dm = new DatabaseManager();
        players.forEach(player -> dm.setBalance(player.method_5845(), player.method_5477().method_10851(), amount));
        ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585("Updated balance of " + players.size() + " players"), false);
        return players.size();
    }

    private static int balanceCommand(CommandContext<class_2168> ctx, @Nullable class_3222 player) throws CommandSyntaxException {
        int bal;
        DatabaseManager dm = new DatabaseManager();
        if (player == null) {
            player = ((class_2168)ctx.getSource()).method_9207();
        }
        if ((bal = dm.getBalance(player.method_5845())) > -1) {
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585(player.method_5477().method_10851() + " has " + bal + " diamonds"), false);
            return 0;
        }
        ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585("No account was found for player with the name \"" + player.method_5477().method_10851() + "\""), false);
        return 1;
    }

    private static int topCommand(CommandContext<class_2168> ctx, int topAmount) throws CommandSyntaxException {
        DatabaseManager dm = new DatabaseManager();
        class_3222 player1 = ((class_2168)ctx.getSource()).method_9207();
        ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585(dm.top(player1.method_5845(), topAmount)), false);
        return 1;
    }

    private static int sendCommand(CommandContext<class_2168> ctx, class_3222 player, int amount) throws CommandSyntaxException {
        DatabaseManager dm = new DatabaseManager();
        class_3222 player1 = ((class_2168)ctx.getSource()).method_9207();
        int bal = dm.getBalance(player1.method_5845());
        int newValue = dm.getBalance(player.method_5845());
        if (!player.method_5845().equals(player1.method_5845())) {
            if (bal >= amount) {
                if (newValue < Integer.MAX_VALUE && newValue > 0) {
                    dm.setBalance(player.method_5845(), player.method_5477().method_10851(), dm.getBalance(player.method_5845()) + amount);
                    dm.setBalance(player1.method_5845(), player1.method_5477().method_10851(), bal - amount);
                    player.method_7353((class_2561)new class_2585("You received " + amount + " diamonds from " + player1.method_5477().method_10851()), false);
                    ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585("Sent " + amount + " diamonds to " + player.method_5477().method_10851()), false);
                } else {
                    ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585("Failed because that would go over the max value"), false);
                }
            } else {
                ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585("You don't have enough diamonds"), false);
            }
        } else {
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2585("You cant send diamonds to yourself"), false);
        }
        return 1;
    }

    private static void dropDiamonds(int amount, class_3222 player) {
        int blockAmount;
        for (blockAmount = amount / 9; blockAmount > 64; blockAmount -= 64) {
            class_1542 itemEntity = player.method_7328(new class_1799((class_1935)class_1802.field_8603, 64), true);
            itemEntity.method_6975();
            itemEntity.method_6984(player.method_5667());
        }
        if (blockAmount > 0) {
            class_1542 itemEntity1 = player.method_7328(new class_1799((class_1935)class_1802.field_8603, blockAmount), true);
            itemEntity1.method_6975();
            itemEntity1.method_6984(player.method_5667());
        }
        if (amount % 9 > 0) {
            class_1542 itemEntity2 = player.method_7328(new class_1799((class_1935)class_1802.field_8477, amount % 9), true);
            itemEntity2.method_6975();
            itemEntity2.method_6984(player.method_5667());
        }
    }
}

