/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.sneakdevs.diamondeconomy;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DatabaseManager {
    public static String url;

    public static void createNewDatabase(File file) {
        url = "jdbc:sqlite:" + file.getPath().replace('\\', '/');
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(url);
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
        DatabaseManager.createNewTable();
    }

    private Connection connect() {
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(url);
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
        return conn;
    }

    public static void createNewTable() {
        String sql = "CREATE TABLE IF NOT EXISTS diamonds (\n\tuuid text PRIMARY KEY,\n\tname text NOT NULL,\n\tmoney integer DEFAULT 0\n);";
        try (Connection conn = DriverManager.getConnection(url);
             Statement stmt = conn.createStatement();){
            stmt.execute(sql);
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
    }

    public void addPlayer(String uuid, String name) {
        String sql = "INSERT INTO diamonds(uuid,name,money) VALUES(?,?,?)";
        try (Connection conn = this.connect();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid);
            pstmt.setString(2, name);
            pstmt.setInt(3, 0);
            pstmt.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getBalance(String uuid) {
        String sql = "SELECT uuid, money FROM diamonds";
        try (Connection conn = this.connect();
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            do {
                if (!rs.next()) return -1;
            } while (!rs.getString("uuid").equals(uuid));
            int n = rs.getInt("money");
            return n;
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
        return -1;
    }

    public void setBalance(String uuid, String name, int money) {
        String sql = "UPDATE diamonds SET name = ? , money = ? WHERE uuid = ?";
        try (Connection conn = this.connect();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(3, uuid);
            pstmt.setInt(2, money);
            pstmt.setString(1, name);
            pstmt.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public String top(String uuid, int topAmount) {
        String sql = "SELECT uuid, name, money FROM diamonds ORDER BY money DESC";
        String rankings = "";
        int i = 0;
        int playerRank = 0;
        try (Connection conn = this.connect();
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next() && (i < topAmount || playerRank == 0)) {
                ++i;
                if (uuid.equals(rs.getString("uuid"))) {
                    playerRank = i;
                }
                if (i > topAmount) continue;
                rankings = rankings.concat(rs.getString("name") + "  " + rs.getInt("money") + "\n");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return rankings.concat("Your rank is: " + playerRank);
    }

    public void setName(String uuid, String name, int money) {
        String sql = "UPDATE diamonds SET name = ? , money = ? WHERE uuid = ?";
        try (Connection conn = this.connect();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(3, uuid);
            pstmt.setInt(2, money);
            pstmt.setString(1, name);
            pstmt.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

