/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.doraemonprops.item;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.teacon.doraemonprops.client.model.BambooCopterModel;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class BambooCopterItem
extends ArmorItem {
    private static final ResourceLocation TEXTURE = new ResourceLocation("doraemon_props", "textures/entity/bamboo_copter.png");
    private static final double UP_DOWN_SPEED = 0.1;

    public BambooCopterItem() {
        super((IArmorMaterial)ArmorMaterial.LEATHER, EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(ItemGroup.field_78040_i));
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (world.field_72995_K) {
            this.adjustPlayerMotion(player);
        }
        player.field_70143_R = 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void adjustPlayerMotion(PlayerEntity player) {
        Vector3d motion = player.func_213322_ci();
        if (this.isJumpKeyDown()) {
            player.func_213293_j(motion.field_72450_a, 0.1, motion.field_72449_c);
            return;
        }
        if (this.isSneakKeyDown()) {
            player.func_213293_j(motion.field_72450_a, -0.1, motion.field_72449_c);
            return;
        }
        if (!player.func_233570_aj_()) {
            player.func_213293_j(motion.field_72450_a, this.getJitterDistance(player.field_70173_aa), motion.field_72449_c);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isJumpKeyDown() {
        return Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isSneakKeyDown() {
        return Minecraft.func_71410_x().field_71474_y.field_228046_af_.func_151470_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    private double getJitterDistance(int ticksExisted) {
        return MathHelper.func_76134_b((float)((float)ticksExisted / 5.0f)) / 100.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A defaultModel) {
        return (A)((Object)new BambooCopterModel(1.02f));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return TEXTURE.toString();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("item.doraemon_props.bamboo_copter.desc"));
    }
}

