/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.client.manual;

import com.mojang.blaze3d.platform.GlStateManager;
import com.oitsjustjose.geolosys.api.GeolosysAPI;
import com.oitsjustjose.geolosys.api.world.DepositMultiOre;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.client.manual.PatronUtil;
import com.oitsjustjose.geolosys.client.manual.pages.BookChapter;
import com.oitsjustjose.geolosys.client.manual.pages.BookPage;
import com.oitsjustjose.geolosys.client.manual.pages.BookPageContents;
import com.oitsjustjose.geolosys.client.manual.pages.BookPageItemDisplay;
import com.oitsjustjose.geolosys.client.manual.pages.BookPageOre;
import com.oitsjustjose.geolosys.client.manual.pages.BookPageText;
import com.oitsjustjose.geolosys.client.manual.pages.BookPageURL;
import com.oitsjustjose.geolosys.client.manual.pages.ChapterLink;
import com.oitsjustjose.geolosys.common.blocks.BlockInit;
import com.oitsjustjose.geolosys.common.config.ClientConfig;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.config.CompatConfig;
import com.oitsjustjose.geolosys.common.items.ItemInit;
import com.oitsjustjose.geolosys.common.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ManualScreen
extends Screen {
    private static final int WIDTH = 146;
    private static final int HEIGHT = 180;
    private static final ResourceLocation BACKGROUND = new ResourceLocation("geolosys", "textures/gui/book.png");
    private static HashMap<String, BookChapter> chapters = new HashMap();
    private String currentChapter = "home";
    private int currentPageNum = 0;
    private BookPage currentPage;
    private String lastChapter;
    private int lastPageNum;
    private ItemStack display = ItemStack.field_190927_a;
    private int left;
    private int top;
    private FontRenderer fontRenderer;
    private Minecraft mc = Minecraft.func_71410_x();

    public ManualScreen() {
        super((ITextComponent)new TranslationTextComponent("item.geolosys.field_manual", new Object[0]));
        this.fontRenderer = this.mc.field_71466_p;
    }

    public static void initPages() {
        BookPageContents home = new BookPageContents("geolosys.guide.page.home.name");
        home.addLink(new ChapterLink("geolosys.guide.chapter.introduction.name", "introduction"));
        home.addLink(new ChapterLink("geolosys.guide.chapter.prospecting.name", "prospecting"));
        home.addLink(new ChapterLink("geolosys.guide.chapter.resources.name", "resources"));
        home.addLink(new ChapterLink("geolosys.guide.chapter.mod_compat.name", "mod_compat"));
        home.addLink(new ChapterLink("geolosys.guide.chapter.patrons.name", "patrons"));
        chapters.put("home", new BookChapter("home"));
        chapters.put("introduction", new BookChapter("introduction", "home"));
        chapters.put("prospecting", new BookChapter("prospecting", "home"));
        chapters.put("resources", new BookChapter("resources", "home"));
        chapters.put("mod_compat", new BookChapter("mod_compat", "home"));
        chapters.put("patrons", new BookChapter("patrons", "home"));
        chapters.get("home").addPage(home);
        BookPageContents introduction = new BookPageContents("geolosys.guide.chapter.introduction.name");
        introduction.addLink(new ChapterLink("geolosys.guide.chapter.getting_started.name", "getting_started"));
        introduction.addLink(new ChapterLink("geolosys.guide.chapter.plutons.name", "plutons"));
        introduction.addLink(new ChapterLink("geolosys.guide.chapter.vanilla_ores.name", "vanilla_ores"));
        introduction.addLink(new ChapterLink("geolosys.guide.chapter.modded_ores.name", "modded_ores"));
        chapters.put("getting_started", new BookChapter("getting_started", "introduction"));
        chapters.put("plutons", new BookChapter("plutons", "introduction"));
        chapters.put("vanilla_ores", new BookChapter("vanilla_ores", "introduction"));
        chapters.put("modded_ores", new BookChapter("modded_ores", "introduction"));
        chapters.get("introduction").addPage(introduction);
        chapters.get("getting_started").addPage(new BookPageText("geolosys.guide.chapter.getting_started.name", "geolosys.guide.chapter.getting_started.text"));
        chapters.get("plutons").addPage(new BookPageText("geolosys.guide.chapter.plutons.name", "geolosys.guide.chapter.plutons.text"));
        chapters.get("vanilla_ores").addPage(new BookPageText("geolosys.guide.chapter.vanilla_ores.name", "geolosys.guide.chapter.vanilla_ores.text"));
        chapters.get("modded_ores").addPage(new BookPageText("geolosys.guide.chapter.modded_ores.name", "geolosys.guide.chapter.modded_ores.text"));
        BookPageContents prospecting = new BookPageContents("geolosys.guide.chapter.prospecting.name");
        prospecting.addLink(new ChapterLink("geolosys.guide.chapter.samples.name", "samples"));
        chapters.put("samples", new BookChapter("samples", "prospecting"));
        chapters.get("samples").addPage(new BookPageItemDisplay("geolosys.guide.chapter.samples.name", "geolosys.guide.chapter.samples_1.text", new ItemStack((IItemProvider)BlockInit.getInstance().getModBlocks().get("geolosys:hematite_ore_sample"))));
        chapters.get("samples").addPage(new BookPageItemDisplay("geolosys.guide.chapter.samples.name", "geolosys.guide.chapter.samples_2.text", new ItemStack((IItemProvider)BlockInit.getInstance().getModBlocks().get("geolosys:hematite_ore_sample"))));
        if (((Boolean)CommonConfig.ENABLE_PRO_PICK.get()).booleanValue()) {
            prospecting.addLink(new ChapterLink("geolosys.guide.chapter.propick.name", "propick"));
            chapters.put("propick", new BookChapter("propick", "prospecting"));
            chapters.get("propick").addPage(new BookPageItemDisplay("geolosys.guide.chapter.propick.name", "geolosys.guide.chapter.propick_1.text", new ItemStack((IItemProvider)ItemInit.getInstance().getModItems().get("geolosys:prospectors_pick"))));
            chapters.get("propick").addPage(new BookPageText("geolosys.guide.chapter.propick.name", "geolosys.guide.chapter.propick_2.text"));
            chapters.get("propick").addPage(new BookPageText("geolosys.guide.chapter.propick.name", "geolosys.guide.chapter.propick_3.text"));
        }
        chapters.get("prospecting").addPage(prospecting);
        ArrayList<BookPageContents> resources = new ArrayList<BookPageContents>();
        resources.add(new BookPageContents("geolosys.guide.chapter.resources.name"));
        int count = 0;
        int page_num = 0;
        ((BookPageContents)resources.get(page_num)).addLink(new ChapterLink("geolosys.guide.chapter.stones.name", "stones"));
        chapters.put("stones", new BookChapter("stones", "resources"));
        chapters.get("stones").addPage(new BookPageItemDisplay("geolosys.guide.chapter.stones.name", "geolosys.guide.chapter.stones.text", new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196654_e), new ItemStack((IItemProvider)Blocks.field_196656_g), new ItemStack((IItemProvider)Blocks.field_196650_c)}));
        if (++count == 12) {
            resources.add(new BookPageContents("geolosys.guide.chapter.resources.name"));
            ++page_num;
            count = 0;
        }
        for (IDeposit ore : GeolosysAPI.plutonRegistry.getOres()) {
            String name = ore.getFriendlyName();
            if (ore instanceof DepositMultiOre) {
                DepositMultiOre multiOre = (DepositMultiOre)ore;
                StringBuilder sb = new StringBuilder();
                for (BlockState state : multiOre.oreBlocks.keySet()) {
                    sb.append(Utils.blockStateToName(state));
                    sb.append(" & ");
                }
                name = sb.toString().substring(0, sb.lastIndexOf(" & "));
            }
            ((BookPageContents)resources.get(page_num)).addLink(new ChapterLink(name, name));
            chapters.put(name, new BookChapter(name, "resources"));
            chapters.get(name).addPage(new BookPageOre(ore));
            if (++count != 12) continue;
            resources.add(new BookPageContents("geolosys.guide.chapter.resources.name"));
            ++page_num;
            count = 0;
        }
        for (BookPageContents contents : resources) {
            chapters.get("resources").addPage(contents);
        }
        BookPageContents modCompat = new BookPageContents("geolosys.guide.chapter.mod_compat.name");
        if (((Boolean)CompatConfig.ENABLE_OSMIUM.get()).booleanValue()) {
            modCompat.addLink(new ChapterLink("geolosys.guide.chapter.mekanism.name", "mekanism"));
            chapters.put("mekanism", new BookChapter("mekanism", "mod_compat"));
            chapters.get("mekanism").addPage(new BookPageItemDisplay("geolosys.guide.chapter.mekanism.name", "geolosys.guide.chapter.mekanism.text", new ItemStack((IItemProvider)ItemInit.getInstance().getModItems().get("geolosys:osmium_cluster"))));
        }
        if (((Boolean)CompatConfig.ENABLE_YELLORIUM.get()).booleanValue()) {
            modCompat.addLink(new ChapterLink("geolosys.guide.chapter.extreme_reactors.name", "extreme_reactors"));
            chapters.put("extreme_reactors", new BookChapter("extreme_reactors", "mod_compat"));
            chapters.get("extreme_reactors").addPage(new BookPageItemDisplay("geolosys.guide.chapter.extreme_reactors.name", "geolosys.guide.chapter.extreme_reactors.text", new ItemStack((IItemProvider)ItemInit.getInstance().getModItems().get("geolosys:yellorium_cluster"))));
        }
        chapters.get("mod_compat").addPage(modCompat);
        ArrayList<BookPage> patrons = new ArrayList<BookPage>();
        ArrayList<String> patronNames = PatronUtil.getInstance().getPatrons();
        if (patronNames.size() == 0) {
            patrons.add(new BookPageURL("geolosys.guide.chapter.patrons.name", "geolosys.guide.chapter.patrons.none.text", "https://patreon.com/oitsjustjose", "geolosys.guide.chapter.patrons.link"));
        } else {
            patrons.add(new BookPageURL("geolosys.guide.chapter.patrons.name", "geolosys.guide.chapter.patrons.desc.text", "https://patreon.com/oitsjustjose", "geolosys.guide.chapter.patrons.link"));
            count = 0;
            page_num = 0;
            int total = 0;
            StringBuilder pageText = new StringBuilder();
            for (String patronName : patronNames) {
                pageText.append("\u2022 ");
                pageText.append(patronName);
                if (count == 12 || ++total == patronNames.size()) {
                    patrons.add(new BookPageText("geolosys.guide.chapter.patrons.name", pageText.toString()));
                    pageText = new StringBuilder();
                    count = 0;
                    ++page_num;
                    continue;
                }
                pageText.append("<br>");
                ++count;
            }
        }
        for (BookPage page : patrons) {
            chapters.get("patrons").addPage(page);
        }
        for (BookChapter chapter : chapters.values()) {
            if (chapter.getPageCount() > 0) continue;
            chapter.addPage(new BookPage(chapter.getName()));
        }
    }

    protected void init() {
        this.top = (this.height - 180) / 2;
        this.left = (this.width - 146) / 2;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.setFocused(null);
        this.renderBackground();
        this.currentPage = chapters.get(this.currentChapter).getPage(this.currentPageNum);
        if (this.currentPageNum != this.lastPageNum || !this.currentChapter.equals(this.lastChapter)) {
            this.resetPage();
        }
        this.lastChapter = this.currentChapter;
        this.lastPageNum = this.currentPageNum;
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.field_71446_o.func_110577_a(BACKGROUND);
        this.blit(this.left, this.top, 0, 0, 146, 180);
        if (this.currentPage != null) {
            String header = null;
            if (this.currentPage.getTitle().contains("&")) {
                StringBuilder sb = new StringBuilder();
                for (String unlocalized : this.currentPage.getTitle().replace(" ", "").split("&")) {
                    sb.append(I18n.func_135052_a((String)unlocalized, (Object[])new Object[0]));
                    sb.append(" & ");
                }
                header = TextFormatting.BOLD + "" + TextFormatting.UNDERLINE + sb.toString().substring(0, sb.toString().lastIndexOf(" & "));
            } else {
                header = TextFormatting.BOLD + "" + TextFormatting.UNDERLINE + I18n.func_135052_a((String)this.currentPage.getTitle(), (Object[])new Object[0]);
            }
            double textScale = (Double)ClientConfig.MANUAL_FONT_SCALE.get();
            List parts = this.fontRenderer.func_78271_c(header, (int)(110.0 / textScale));
            if (parts.size() > 1) {
                int topToDraw = this.top - 12 * parts.size();
                for (String str : parts) {
                    int width = this.fontRenderer.func_78256_a(str);
                    this.fontRenderer.func_211126_b(str, (float)this.left + (float)(146 - width) / 2.0f, (float)topToDraw, 0x777777);
                    topToDraw += 12;
                }
            } else {
                int headerWidth = this.fontRenderer.func_78256_a(header);
                this.fontRenderer.func_211126_b(header, (float)this.left + (float)(146 - headerWidth) / 2.0f, (float)(this.top + 12), 0);
            }
            if (this.currentPage instanceof BookPageItemDisplay) {
                this.renderItemDisplayPage((BookPageItemDisplay)this.currentPage, mouseX, mouseY);
            } else if (this.currentPage instanceof BookPageText) {
                this.renderTextPage((BookPageText)this.currentPage);
            } else if (this.currentPage instanceof BookPageOre) {
                this.renderOrePage((BookPageOre)this.currentPage, mouseX, mouseY);
            } else if (this.currentPage instanceof BookPageURL) {
                this.renderURLPage((BookPageURL)this.currentPage, mouseX, mouseY, partialTicks);
            }
            if (chapters.get(this.currentChapter).getPageCount() > 1) {
                GlStateManager.pushMatrix();
                GlStateManager.scaled((double)textScale, (double)textScale, (double)textScale);
                String pageNum = this.currentPageNum + 1 + "/" + chapters.get(this.currentChapter).getPageCount();
                int pageNumWidth = (int)((double)this.fontRenderer.func_78256_a(pageNum) * textScale);
                int x = (int)((double)(this.left + (146 - pageNumWidth) / 2) / textScale);
                this.fontRenderer.func_78279_b(pageNum, x, (int)((double)(this.top + 164) / textScale), (int)(110.0 / textScale), 0);
                GlStateManager.popMatrix();
            }
        }
        super.render(mouseX, mouseY, partialTicks);
    }

    private void renderItemDisplayPage(BookPageItemDisplay page, int mouseX, int mouseY) {
        ItemStack stack = page.getDisplayStack();
        if (stack.func_77973_b() != this.display.func_77973_b()) {
            this.display = stack;
        }
        GlStateManager.pushMatrix();
        GlStateManager.scalef((float)2.0f, (float)2.0f, (float)2.0f);
        RenderHelper.func_74520_c();
        int itemX = this.left + 57;
        int itemY = this.top + 24;
        float itemScale = 2.0f;
        this.itemRenderer.func_180450_b(this.display, (int)((float)itemX / itemScale), (int)((float)itemY / itemScale));
        RenderHelper.func_74518_a();
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        float textScale = ((Double)ClientConfig.MANUAL_FONT_SCALE.get()).floatValue();
        GlStateManager.scalef((float)textScale, (float)textScale, (float)textScale);
        this.fontRenderer.func_78279_b(I18n.func_135052_a((String)page.getDescription(), (Object[])new Object[0]), (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + 58) / textScale), (int)(110.0f / textScale), 0);
        GlStateManager.popMatrix();
        this.renderTooltip(mouseX, mouseY, itemX, itemY, itemScale);
    }

    private void renderURLPage(BookPageURL page, int mouseX, int mouseY, float partialTicks) {
        int i;
        GlStateManager.pushMatrix();
        float textScale = ((Double)ClientConfig.MANUAL_FONT_SCALE.get()).floatValue();
        GlStateManager.scalef((float)textScale, (float)textScale, (float)textScale);
        String text = I18n.func_135052_a((String)page.getText(), (Object[])new Object[0]);
        ArrayList<String> paragraphs = new ArrayList<String>();
        int numOccurences = 0;
        while (text.contains("|")) {
            i = text.indexOf("|");
            paragraphs.add("    " + text.substring(0, i));
            if (i < text.length() - 1) {
                text = text.substring(i + 1);
            }
            ++numOccurences;
        }
        paragraphs.add((numOccurences > 0 ? "    " : "") + text);
        i = 24;
        for (String par : paragraphs) {
            this.fontRenderer.func_78279_b(par, (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + i) / textScale), (int)(110.0f / textScale), 0);
            i += (int)(2.0f + (float)this.fontRenderer.func_78267_b(par, (int)(110.0f / textScale)) * textScale);
        }
        GlStateManager.popMatrix();
    }

    private void renderOrePage(BookPageOre page, int mouseX, int mouseY) {
        ItemStack stack = page.getDisplayStack();
        if (stack.func_77973_b() != this.display.func_77973_b()) {
            this.display = stack;
        }
        GlStateManager.pushMatrix();
        GlStateManager.scalef((float)2.0f, (float)2.0f, (float)2.0f);
        RenderHelper.func_74520_c();
        int itemX = this.left + 57;
        int itemY = this.top + 24;
        float itemScale = 2.0f;
        this.itemRenderer.func_180450_b(this.display, (int)((float)itemX / itemScale), (int)((float)itemY / itemScale));
        RenderHelper.func_74518_a();
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        float textScale = ((Double)ClientConfig.MANUAL_FONT_SCALE.get()).floatValue();
        GlStateManager.scalef((float)textScale, (float)textScale, (float)textScale);
        String minDepthFromSeaLevel = this.getFormattedSeaLevel(this.mc.field_71441_e.func_181545_F() - page.getMinY());
        String maxDepthFromSeaLevel = this.getFormattedSeaLevel(this.mc.field_71441_e.func_181545_F() - page.getMaxY());
        String description = page.isBiomeRestricted() && page.isMultiOre() ? I18n.func_135052_a((String)"geolosys.guide.chapter.ore.mutli.biome.description", (Object[])new Object[]{page.getFriendlyName(), minDepthFromSeaLevel, maxDepthFromSeaLevel, page.getBiomes(), page.getChance(), page.getType(), page.getSize(), page.getHarvestLevel()}) : (page.isMultiOre() ? I18n.func_135052_a((String)"geolosys.guide.chapter.ore.multi.description", (Object[])new Object[]{page.getFriendlyName(), minDepthFromSeaLevel, maxDepthFromSeaLevel, page.getChance(), page.getType(), page.getSize(), page.getHarvestLevel()}) : (page.isBiomeRestricted() ? I18n.func_135052_a((String)"geolosys.guide.chapter.ore.biome.description", (Object[])new Object[]{page.getFriendlyName(), minDepthFromSeaLevel, maxDepthFromSeaLevel, page.getBiomes(), page.getChance(), page.getType(), page.getSize(), page.getHarvestLevel()}) : I18n.func_135052_a((String)"geolosys.guide.chapter.ore.description", (Object[])new Object[]{page.getFriendlyName(), minDepthFromSeaLevel, maxDepthFromSeaLevel, page.getChance(), page.getType(), page.getSize(), page.getHarvestLevel()})));
        this.fontRenderer.func_78279_b(description, (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + 58) / textScale), (int)(110.0f / textScale), 0);
        GlStateManager.popMatrix();
        this.renderTooltip(mouseX, mouseY, itemX, itemY, itemScale);
    }

    private String getFormattedSeaLevel(int depth) {
        if (depth > 0) {
            return I18n.func_135052_a((String)"geolosys.guide.generic.belowsealevel", (Object[])new Object[]{Math.abs(depth)});
        }
        if (depth < 0) {
            return I18n.func_135052_a((String)"geolosys.guide.generic.abovesealevel", (Object[])new Object[]{Math.abs(depth)});
        }
        return I18n.func_135052_a((String)"geolosys.guide.generic.atsealevel", (Object[])new Object[0]);
    }

    private void renderTooltip(int mouseX, int mouseY, int itemX, int itemY, float itemScale) {
        if (mouseX >= itemX && mouseY >= itemY && (float)mouseX <= (float)itemX + 16.0f * itemScale && (float)mouseY <= (float)itemY + 16.0f * itemScale) {
            GlStateManager.pushMatrix();
            float toolTipScale = 0.85f;
            GlStateManager.scalef((float)toolTipScale, (float)toolTipScale, (float)toolTipScale);
            this.renderTooltip(this.display, (int)((float)mouseX / toolTipScale), (int)((float)mouseY / toolTipScale));
            RenderHelper.func_74518_a();
            GlStateManager.popMatrix();
        }
    }

    private void renderTextPage(BookPageText page) {
        int i;
        GlStateManager.pushMatrix();
        float textScale = ((Double)ClientConfig.MANUAL_FONT_SCALE.get()).floatValue();
        GlStateManager.scalef((float)textScale, (float)textScale, (float)textScale);
        String text = I18n.func_135052_a((String)page.getText(), (Object[])new Object[0]);
        ArrayList<String> paragraphs = new ArrayList<String>();
        while (text.contains("|") || text.contains("<br>")) {
            i = text.indexOf("|");
            int j = text.indexOf("<br>");
            if (i == -1) {
                paragraphs.add(text.substring(0, j));
                if (j >= text.length() - 1) continue;
                text = text.substring(j + 4);
                continue;
            }
            if (j == -1) {
                paragraphs.add("    " + text.substring(0, i));
                if (i >= text.length() - 1) continue;
                text = text.substring(i + 1);
                continue;
            }
            if (i < j) {
                paragraphs.add("    " + text.substring(0, i));
                if (i >= text.length() - 1) continue;
                text = text.substring(i + 1);
                continue;
            }
            paragraphs.add(text.substring(0, j));
            if (j >= text.length() - 1) continue;
            text = text.substring(j + 4);
        }
        paragraphs.add(text);
        i = 24;
        for (String par : paragraphs) {
            this.fontRenderer.func_78279_b(par, (int)((float)(this.left + 18) / textScale), (int)((float)(this.top + i) / textScale), (int)(110.0f / textScale), 0);
            i += (int)(2.0f + (float)this.fontRenderer.func_78267_b(par, (int)(110.0f / textScale)) * textScale);
        }
        GlStateManager.popMatrix();
    }

    private void resetPage() {
        this.buttons.clear();
        this.children.clear();
        int i = 0;
        if (this.currentPage instanceof BookPageContents) {
            List<ChapterLink> links = ((BookPageContents)this.currentPage).getLinks();
            for (ChapterLink link : links) {
                this.addButton((Widget)new ChapterLinkButton(this.mc, this.left + 16, this.top + 24 + i * 12, link.text, link.chapter));
                ++i;
            }
        } else if (this.currentPage instanceof BookPageURL) {
            GuiButtonURL urlButton = new GuiButtonURL(this.left, this.top + 180, 146, 20, I18n.func_135052_a((String)((BookPageURL)this.currentPage).getButtonText(), (Object[])new Object[0]), ((BookPageURL)this.currentPage).getURL());
            this.addButton((Widget)urlButton);
        }
        if (this.currentPageNum < chapters.get(this.currentChapter).getPageCount() - 1) {
            this.addButton((Widget)new PageTurnButton(this.left + 100, this.top + 154, true));
        }
        if (this.currentPageNum > 0) {
            this.addButton((Widget)new PageTurnButton(this.left + 18, this.top + 154, false));
        }
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.mc.field_71474_y.field_151445_Q.func_151468_f()) {
            if (this.currentChapter.equals(chapters.get(this.currentChapter).getParent())) {
                this.mc.func_147108_a(null);
                this.mc.func_213228_a(true);
            } else {
                this.currentChapter = chapters.get(this.currentChapter).getParent();
                this.currentPageNum = 0;
            }
        } else if (1 == p_keyPressed_2_) {
            this.mc.func_147108_a(null);
            this.mc.func_213228_a(true);
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 1) {
            this.currentChapter = chapters.get(this.currentChapter).getParent();
            this.currentPageNum = 0;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void resize(@Nonnull Minecraft mc, int w, int h) {
        super.resize(mc, w, h);
        this.resetPage();
    }

    @OnlyIn(value=Dist.CLIENT)
    public class PageTurnButton
    extends Button {
        private final boolean isForward;

        PageTurnButton(int x, int y, boolean isForward) {
            super(x, y, 23, 13, "", null);
            this.isForward = isForward;
        }

        public void onPress() {
            if (this.isForward) {
                ManualScreen.this.currentPageNum++;
            } else {
                ManualScreen.this.currentPageNum--;
            }
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            if (this.visible) {
                boolean flag = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND);
                int i = 0;
                int j = 192;
                if (flag) {
                    i += 23;
                }
                if (!this.isForward) {
                    j += 13;
                }
                this.blit(this.x, this.y, i, j, 23, 13);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ChapterLinkButton
    extends Button {
        private String unlocButtonText;
        private String chapter;
        private Minecraft mc;

        ChapterLinkButton(Minecraft mc, int x, int y, String buttonText, String chapter) {
            int n = mc.field_71466_p.func_78256_a(I18n.func_135052_a((String)buttonText, (Object[])new Object[0]));
            mc.field_71466_p.getClass();
            super(x, y, n, 9, buttonText, null);
            this.unlocButtonText = buttonText;
            this.chapter = chapter;
            this.mc = mc;
        }

        public void onPress() {
            ManualScreen.this.currentChapter = this.chapter;
            ManualScreen.this.currentPageNum = 0;
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            if (this.visible) {
                FontRenderer fontrenderer = this.mc.field_71466_p;
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
                int j = 0;
                String p = "";
                if (!this.active) {
                    j = 0xA0A0A0;
                } else if (this.isHovered) {
                    j = 8308926;
                    p = p + TextFormatting.UNDERLINE;
                }
                String toDraw = I18n.func_135052_a((String)this.unlocButtonText, (Object[])new Object[0]);
                if (toDraw.contains("&")) {
                    StringBuilder sb = new StringBuilder();
                    for (String unlocalized : toDraw.split(" & ")) {
                        sb.append(I18n.func_135052_a((String)unlocalized, (Object[])new Object[0]));
                        sb.append(" & ");
                    }
                    toDraw = sb.toString().substring(0, sb.toString().lastIndexOf(" & "));
                }
                if (fontrenderer.func_78256_a(p + "\u2022 " + toDraw) > (int)(110.0 / (Double)ClientConfig.MANUAL_FONT_SCALE.get())) {
                    toDraw = ManualScreen.this.fontRenderer.func_78269_a(toDraw, (int)(110.0 / (Double)ClientConfig.MANUAL_FONT_SCALE.get()));
                    toDraw = toDraw.substring(0, toDraw.length() - 7);
                    toDraw = toDraw + "...";
                }
                fontrenderer.func_78279_b(p + "\u2022 " + toDraw, this.x, this.y, (int)(110.0 / (Double)ClientConfig.MANUAL_FONT_SCALE.get()), j);
            }
        }

        public String getChapter() {
            return this.chapter;
        }
    }

    private static class GuiButtonURL
    extends Button {
        GuiButtonURL(int x, int y, int widthIn, int heightIn, String buttonText, final String url) {
            super(x, y, widthIn, heightIn, buttonText, new Button.IPressable(){

                public void onPress(@Nonnull Button button) {
                    Util.func_110647_a().func_195640_a(url);
                }
            });
        }
    }
}

