/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.api;

import java.io.Serializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public class ChunkPosDim
implements Serializable {
    private static final long serialVersionUID = 6006452707959877895L;
    private int x;
    private int z;
    private String dim;

    public ChunkPosDim(ChunkPos pos, String dim) {
        this(pos.field_77276_a, pos.field_77275_b, dim);
    }

    public ChunkPosDim(BlockPos pos, String dim) {
        this(new ChunkPos(pos), dim);
    }

    public ChunkPosDim(int x, int z, String dim) {
        this.x = x;
        this.z = z;
        this.dim = dim;
    }

    public ChunkPosDim(String asString) {
        String[] parts = asString.replace("[", "").replace("]", "").split(",");
        assert (parts.length == 3);
        this.x = Integer.parseInt(parts[0]);
        this.z = Integer.parseInt(parts[1]);
        this.dim = parts[2];
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public String getDimension() {
        return this.dim;
    }

    public ChunkPos toChunkPos() {
        return new ChunkPos(this.x, this.z);
    }

    public String toString() {
        return "[" + this.getX() + "," + this.getZ() + "," + this.getDimension() + "]";
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ChunkPosDim) {
            ChunkPosDim c = (ChunkPosDim)other;
            return c.getX() == this.getX() && c.getZ() == this.getZ() && c.getDimension().equalsIgnoreCase(this.getDimension());
        }
        return false;
    }
}

