/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.api.world;

import com.oitsjustjose.geolosys.api.PlutonType;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.common.utils.Utils;
import java.util.List;
import net.minecraft.block.BlockState;

public class Deposit
implements IDeposit {
    private BlockState oreBlock;
    private BlockState sampleBlock;
    private int yMin;
    private int yMax;
    private int size;
    private int chance;
    private String[] dimensionBlacklist;
    private List<BlockState> blockStateMatchers;
    private PlutonType type;
    private float density;

    public Deposit(BlockState oreBlock, BlockState sampleBlock, int yMin, int yMax, int size, int chance, String[] dimensionBlacklist, List<BlockState> blockStateMatchers, PlutonType type, float density) {
        this.oreBlock = oreBlock;
        this.sampleBlock = sampleBlock;
        this.yMin = yMin;
        this.yMax = yMax;
        this.size = size;
        this.chance = chance;
        this.dimensionBlacklist = dimensionBlacklist;
        this.blockStateMatchers = blockStateMatchers;
        this.type = type;
        this.density = density;
    }

    @Override
    public BlockState getOre() {
        return this.oreBlock;
    }

    @Override
    public BlockState getSample() {
        return this.sampleBlock;
    }

    @Override
    public int getYMin() {
        return this.yMin;
    }

    @Override
    public int getYMax() {
        return this.yMax;
    }

    @Override
    public int getChance() {
        return this.chance;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public String[] getDimensionBlacklist() {
        return this.dimensionBlacklist;
    }

    @Override
    public boolean canReplace(BlockState state) {
        if (this.blockStateMatchers == null) {
            return true;
        }
        for (BlockState s : this.blockStateMatchers) {
            if (!Utils.doStatesMatch(s, state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BlockState> getBlockStateMatchers() {
        return this.blockStateMatchers;
    }

    @Override
    public boolean oreMatches(BlockState other) {
        return Utils.doStatesMatch(this.oreBlock, other);
    }

    @Override
    public boolean sampleMatches(BlockState other) {
        return Utils.doStatesMatch(this.sampleBlock, other);
    }

    @Override
    public PlutonType getPlutonType() {
        return this.type;
    }

    @Override
    public float getDensity() {
        return this.density;
    }

    @Override
    public String getFriendlyName() {
        return Utils.blockStateToName(this.getOre());
    }
}

