/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.items;

import com.google.common.collect.Maps;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.config.CompatConfig;
import com.oitsjustjose.geolosys.common.items.ManualItem;
import com.oitsjustjose.geolosys.common.items.ProPickItem;
import com.oitsjustjose.geolosys.common.items.Types;
import com.oitsjustjose.geolosys.common.utils.GeolosysGroup;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemInit {
    private static ItemInit instance;
    private HashMap<String, Item> items = Maps.newHashMap();
    private HashMap<Item, Integer> burnTimes = Maps.newHashMap();

    private ItemInit() {
        Item item;
        Item.Properties itemProps;
        if (((Boolean)CommonConfig.ENABLE_COALS.get()).booleanValue()) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        for (Types.Cluster cluster : Types.Cluster.values()) {
            if (cluster == Types.Cluster.YELLORIUM && !((Boolean)CompatConfig.ENABLE_YELLORIUM.get()).booleanValue() || cluster == Types.Cluster.OSMIUM && !((Boolean)CompatConfig.ENABLE_OSMIUM.get()).booleanValue()) continue;
            itemProps = new Item.Properties().func_200916_a((ItemGroup)GeolosysGroup.getInstance());
            item = (Item)new Item(itemProps).setRegistryName("geolosys", cluster.func_176610_l() + "_cluster");
            this.items.put(item.getRegistryName().toString(), item);
        }
        if (((Boolean)CommonConfig.ENABLE_INGOTS.get()).booleanValue()) {
            for (Enum enum_ : Types.Ingot.values()) {
                itemProps = new Item.Properties().func_200916_a((ItemGroup)GeolosysGroup.getInstance());
                item = (Item)new Item(itemProps).setRegistryName("geolosys", ((Types.Ingot)enum_).func_176610_l() + "_ingot");
                this.items.put(item.getRegistryName().toString(), item);
            }
        }
        if (((Boolean)CommonConfig.ENABLE_COALS.get()).booleanValue()) {
            for (Enum enum_ : Types.Coal.values()) {
                itemProps = new Item.Properties().func_200916_a((ItemGroup)GeolosysGroup.getInstance());
                item = (Item)new Item(itemProps).setRegistryName("geolosys", ((Types.Coal)enum_).func_176610_l() + "_coal");
                this.items.put(item.getRegistryName().toString(), item);
                this.burnTimes.put(item, ((Types.Coal)enum_).getBurnTime());
            }
            for (Enum enum_ : Types.CoalCoke.values()) {
                itemProps = new Item.Properties().func_200916_a((ItemGroup)GeolosysGroup.getInstance());
                item = (Item)new Item(itemProps).setRegistryName("geolosys", ((Types.CoalCoke)enum_).func_176610_l() + "_coal_coke");
                this.items.put(item.getRegistryName().toString(), item);
                this.burnTimes.put(item, ((Types.CoalCoke)enum_).getBurnTime());
            }
        }
        this.items.put(ManualItem.REGISTRY_NAME.toString(), new ManualItem());
        this.items.put(ProPickItem.REGISTRY_NAME.toString(), new ProPickItem());
    }

    public static ItemInit getInstance() {
        if (instance == null) {
            instance = new ItemInit();
        }
        return instance;
    }

    public void register(RegistryEvent.Register<Item> itemRegistryEvent) {
        for (Item i : this.getModItems().values()) {
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)i);
        }
    }

    public HashMap<Item, Integer> getModFuels() {
        return (HashMap)this.burnTimes.clone();
    }

    @SubscribeEvent
    public void onFuelRegistry(FurnaceFuelBurnTimeEvent fuelBurnoutEvent) {
        if (((Boolean)CommonConfig.ENABLE_COALS.get()).booleanValue()) {
            for (Map.Entry<Item, Integer> fuelPair : ItemInit.getInstance().getModFuels().entrySet()) {
                if (!fuelBurnoutEvent.getItemStack().func_77973_b().equals(fuelPair.getKey())) continue;
                fuelBurnoutEvent.setBurnTime(fuelPair.getValue() * 200);
            }
        }
    }

    public HashMap<String, Item> getModItems() {
        return (HashMap)this.items.clone();
    }
}

