/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.utils;

import com.oitsjustjose.geolosys.api.GeolosysAPI;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.Dimension;
import net.minecraftforge.common.ToolType;

public class Utils {
    private static ArrayList<BlockState> defaultMatchersCached = null;

    public static String blockStateToName(BlockState state) {
        return I18n.func_135052_a((String)state.func_177230_c().func_149739_a(), (Object[])new Object[0]);
    }

    public static ItemStack blockStateToStack(BlockState state) {
        return new ItemStack((IItemProvider)state.func_177230_c().func_199767_j(), 1);
    }

    public static boolean doStatesMatch(BlockState state1, BlockState state2) {
        return state1.func_177230_c().getRegistryName() == state2.func_177230_c().getRegistryName();
    }

    public static String dimensionToString(Dimension dim) {
        return Objects.requireNonNull(dim.func_186058_p().getRegistryName().toString());
    }

    public static BlockPos getTopSolidBlock(IWorld world, BlockPos start) {
        BlockPos retPos = new BlockPos(start.func_177958_n(), world.func_217301_I() - 1, start.func_177952_p());
        while (retPos.func_177956_o() > 0 && !world.func_180495_p(retPos).func_185904_a().func_76220_a()) {
            retPos = retPos.func_177977_b();
        }
        return retPos;
    }

    public static ArrayList<BlockState> getDefaultMatchers() {
        return (ArrayList)defaultMatchersCached.clone();
    }

    public static boolean addDefaultMatcher(Block block) {
        BlockState defaultState;
        if (defaultMatchersCached == null) {
            defaultMatchersCached = new ArrayList();
            GeolosysAPI.plutonRegistry.getStones().forEach(x -> defaultMatchersCached.add(x.getOre()));
        }
        if (!(defaultState = block.func_176223_P()).func_196958_f()) {
            defaultMatchersCached.add(defaultState);
            return true;
        }
        return false;
    }

    public static boolean canMine(BlockState state, ItemStack stack) {
        int harvestLvl = stack.getHarvestLevel(ToolType.PICKAXE, null, null);
        return stack.getToolTypes().contains(ToolType.PICKAXE) && state.getHarvestLevel() <= harvestLvl;
    }
}

