/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world;

import com.oitsjustjose.geolosys.api.world.DepositBiomeRestricted;
import com.oitsjustjose.geolosys.api.world.DepositMultiOreBiomeRestricted;
import com.oitsjustjose.geolosys.api.world.DepositStone;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.common.world.feature.PlutonOreFeature;
import com.oitsjustjose.geolosys.common.world.feature.PlutonStoneFeature;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.registries.ForgeRegistries;

public class PlutonRegistry {
    private ArrayList<IDeposit> ores = new ArrayList();
    private ArrayList<IDeposit> oreWeightList = new ArrayList();
    private ArrayList<DepositStone> stones = new ArrayList();
    private ArrayList<DepositStone> stoneWeightList = new ArrayList();

    public ArrayList<IDeposit> getOres() {
        return (ArrayList)this.ores.clone();
    }

    public ArrayList<IDeposit> getStones() {
        return (ArrayList)this.stones.clone();
    }

    public boolean addOrePluton(IDeposit ore) {
        if (ore instanceof DepositStone) {
            return this.addStonePluton((DepositStone)ore);
        }
        for (int i = 0; i < ore.getChance(); ++i) {
            this.oreWeightList.add(ore);
        }
        return this.ores.add(ore);
    }

    public boolean addStonePluton(DepositStone stone) {
        for (int i = 0; i < stone.getChance(); ++i) {
            this.stoneWeightList.add(stone);
        }
        return this.stones.add(stone);
    }

    public IDeposit pickPluton(IWorld world, BlockPos pos, Random rand) {
        if (this.oreWeightList.size() > 0) {
            if (rand.nextBoolean()) {
                Biome b = world.func_226691_t_(pos);
                ArrayList<IDeposit> forBiome = new ArrayList<IDeposit>();
                for (IDeposit d : this.ores) {
                    if (d instanceof DepositBiomeRestricted) {
                        if (!((DepositBiomeRestricted)d).canPlaceInBiome(b)) continue;
                        forBiome.add(d);
                        continue;
                    }
                    if (!(d instanceof DepositMultiOreBiomeRestricted) || !((DepositMultiOreBiomeRestricted)d).canPlaceInBiome(b)) continue;
                    forBiome.add(d);
                }
                if (forBiome.size() > 0) {
                    int pick = rand.nextInt(forBiome.size());
                    return (IDeposit)forBiome.get(pick);
                }
            }
            int pick = rand.nextInt(this.oreWeightList.size());
            return this.oreWeightList.get(pick);
        }
        return null;
    }

    public DepositStone pickStone() {
        if (this.stoneWeightList.size() > 0) {
            Random random = new Random();
            int pick = random.nextInt(this.stoneWeightList.size());
            return this.stoneWeightList.get(pick);
        }
        return null;
    }

    public void registerAsOreGenerator() {
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, new ConfiguredFeature((Feature)new PlutonOreFeature(NoFeatureConfig::func_214639_a), (IFeatureConfig)new NoFeatureConfig()));
        }
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, new ConfiguredFeature((Feature)new PlutonStoneFeature(NoFeatureConfig::func_214639_a), (IFeatureConfig)new NoFeatureConfig()));
        }
    }
}

