/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world.capability;

import com.oitsjustjose.geolosys.api.BlockPosDim;
import com.oitsjustjose.geolosys.api.ChunkPosDim;
import com.oitsjustjose.geolosys.common.world.capability.IGeolosysCapability;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;

public class GeolosysCapability
implements IGeolosysCapability {
    private Map<ChunkPosDim, Boolean> oreGenMap = new ConcurrentHashMap<ChunkPosDim, Boolean>();
    private Map<ChunkPosDim, Boolean> stoneGenMap = new ConcurrentHashMap<ChunkPosDim, Boolean>();
    private Map<BlockPosDim, BlockState> pendingBlocks = new ConcurrentHashMap<BlockPosDim, BlockState>();
    private Map<UUID, Boolean> giveMap = new ConcurrentHashMap<UUID, Boolean>();

    @Override
    public Map<ChunkPosDim, Boolean> getOreGenMap() {
        return this.oreGenMap;
    }

    @Override
    public Map<ChunkPosDim, Boolean> getStoneGenMap() {
        return this.stoneGenMap;
    }

    @Override
    public Map<BlockPosDim, BlockState> getPendingBlocks() {
        return this.pendingBlocks;
    }

    @Override
    public void putPendingBlock(BlockPosDim pos, BlockState state) {
        this.pendingBlocks.put(pos, state);
    }

    @Override
    public BlockState getPendingBlock(BlockPosDim pos) {
        BlockState ret = this.pendingBlocks.get(pos);
        return ret;
    }

    @Override
    public void setOrePlutonGenerated(ChunkPosDim dim) {
        this.oreGenMap.put(dim, true);
    }

    @Override
    public boolean hasOrePlutonGenerated(ChunkPosDim pos) {
        return this.oreGenMap.containsKey(pos) && this.oreGenMap.get(pos) != false;
    }

    @Override
    public void setStonePlutonGenerated(ChunkPosDim dim) {
        this.stoneGenMap.put(dim, true);
    }

    @Override
    public boolean hasStonePlutonGenerated(ChunkPosDim pos) {
        return this.stoneGenMap.containsKey(pos) && this.stoneGenMap.get(pos) != false;
    }

    @Override
    public boolean hasPlayerReceivedManual(UUID uuid) {
        return this.giveMap.containsKey(uuid);
    }

    @Override
    public void setPlayerReceivedManual(UUID uuid) {
        this.giveMap.put(uuid, true);
    }

    @Override
    public Map<UUID, Boolean> getGivenMap() {
        return this.giveMap;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("WorldOreDeposits", (INBT)new CompoundNBT());
        compound.func_218657_a("WorldStoneDeposits", (INBT)new CompoundNBT());
        compound.func_218657_a("PendingBlocks", (INBT)new CompoundNBT());
        compound.func_218657_a("PlayersGifted", (INBT)new CompoundNBT());
        CompoundNBT oreDeposits = compound.func_74775_l("WorldOreDeposits");
        CompoundNBT stoneDeposits = compound.func_74775_l("WorldStoneDeposits");
        CompoundNBT pendingBlocks = compound.func_74775_l("PendingBlocks");
        CompoundNBT playersGifted = compound.func_74775_l("PlayersGifted");
        this.getOreGenMap().forEach((x, y) -> oreDeposits.func_74757_a(x.toString(), y.booleanValue()));
        this.getStoneGenMap().forEach((x, y) -> stoneDeposits.func_74757_a(x.toString(), y.booleanValue()));
        this.getPendingBlocks().forEach((x, y) -> pendingBlocks.func_218657_a(x.toString(), (INBT)NBTUtil.func_190009_a((BlockState)y)));
        this.getGivenMap().forEach((x, y) -> playersGifted.func_74757_a(x.toString(), y.booleanValue()));
        return compound;
    }

    public void deserializeNBT(CompoundNBT compound) {
        CompoundNBT oreDeposits = compound.func_74775_l("WorldOreDeposits");
        CompoundNBT stoneDeposits = compound.func_74775_l("WorldStoneDeposits");
        CompoundNBT pendingBlocks = compound.func_74775_l("PendingBlocks");
        CompoundNBT playersGifted = compound.func_74775_l("PlayersGifted");
        oreDeposits.func_150296_c().forEach(key -> this.setOrePlutonGenerated(new ChunkPosDim((String)key)));
        stoneDeposits.func_150296_c().forEach(key -> this.setStonePlutonGenerated(new ChunkPosDim((String)key)));
        pendingBlocks.func_150296_c().forEach(key -> this.putPendingBlock(new BlockPosDim((String)key), NBTUtil.func_190008_d((CompoundNBT)((CompoundNBT)Objects.requireNonNull(pendingBlocks.func_74781_a(key))))));
        playersGifted.func_150296_c().forEach(key -> this.setPlayerReceivedManual(UUID.fromString(key)));
    }
}

