/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world.feature;

import com.mojang.datafixers.Dynamic;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.api.BlockPosDim;
import com.oitsjustjose.geolosys.api.ChunkPosDim;
import com.oitsjustjose.geolosys.api.GeolosysAPI;
import com.oitsjustjose.geolosys.api.world.DepositStone;
import com.oitsjustjose.geolosys.common.utils.Utils;
import com.oitsjustjose.geolosys.common.world.capability.IGeolosysCapability;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class PlutonStoneFeature
extends Feature<NoFeatureConfig> {
    public PlutonStoneFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    private boolean isInChunk(ChunkPos chunkPos, BlockPos pos) {
        int blockX = pos.func_177958_n();
        int blockZ = pos.func_177952_p();
        return blockX >= chunkPos.func_180334_c() && blockX <= chunkPos.func_180332_e() && blockZ >= chunkPos.func_180333_d() && blockZ <= chunkPos.func_180330_f();
    }

    @ParametersAreNonnullByDefault
    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        IGeolosysCapability plutonCapability = (IGeolosysCapability)worldIn.func_201672_e().getCapability(GeolosysAPI.GEOLOSYS_WORLD_CAPABILITY).orElse(null);
        ChunkPosDim chunkPosDim = new ChunkPosDim(pos, Objects.requireNonNull(worldIn.func_201675_m().func_186058_p().getRegistryName()).toString());
        if (plutonCapability == null) {
            Geolosys.getInstance().LOGGER.error("No PlutonCapability present -- things will likely break.");
            return false;
        }
        if (plutonCapability.hasStonePlutonGenerated(chunkPosDim)) {
            return false;
        }
        DepositStone pluton = GeolosysAPI.plutonRegistry.pickStone();
        if (pluton == null) {
            return false;
        }
        List dimTypes = ((Stream)Arrays.stream(pluton.getDimensionBlacklist()).parallel()).map(x -> DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(x))).collect(Collectors.toList());
        if (dimTypes.contains(worldIn.func_201675_m().func_186058_p())) {
            return false;
        }
        int randY = pluton.getYMin() + rand.nextInt(pluton.getYMax() - pluton.getYMin());
        float f = rand.nextFloat() * (float)Math.PI;
        double d0 = (float)(pos.func_177958_n() + 8) + MathHelper.func_76126_a((float)f) * (float)pluton.getSize() / 8.0f;
        double d1 = (float)(pos.func_177958_n() + 8) - MathHelper.func_76126_a((float)f) * (float)pluton.getSize() / 8.0f;
        double d2 = (float)(pos.func_177952_p() + 8) + MathHelper.func_76134_b((float)f) * (float)pluton.getSize() / 8.0f;
        double d3 = (float)(pos.func_177952_p() + 8) - MathHelper.func_76134_b((float)f) * (float)pluton.getSize() / 8.0f;
        double d4 = randY + rand.nextInt(3) - 2;
        double d5 = randY + rand.nextInt(3) - 2;
        ChunkPos thisChunk = new ChunkPos(pos);
        boolean placed = false;
        for (int i = 0; i < pluton.getSize(); ++i) {
            float f1 = (float)i / (float)pluton.getSize();
            double d6 = d0 + (d1 - d0) * (double)f1;
            double d7 = d4 + (d5 - d4) * (double)f1;
            double d8 = d2 + (d3 - d2) * (double)f1;
            double d9 = rand.nextDouble() * (double)pluton.getSize() / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * f1)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * f1)) + 1.0f) * d9 + 1.0;
            int j = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
            int k = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int l = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
            int i1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
            int j1 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int k1 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
            for (int l1 = j; l1 <= i1; ++l1) {
                double d12 = ((double)l1 + 0.5 - d6) / (d10 / 2.0);
                if (!(d12 * d12 < 1.0)) continue;
                for (int i2 = k; i2 <= j1; ++i2) {
                    double d13 = ((double)i2 + 0.5 - d7) / (d11 / 2.0);
                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                    block3: for (int j2 = l; j2 <= k1; ++j2) {
                        double d14 = ((double)j2 + 0.5 - d8) / (d10 / 2.0);
                        if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0)) continue;
                        BlockPos blockpos = new BlockPos(l1, i2, j2);
                        if (this.isInChunk(thisChunk, blockpos) || worldIn.func_217354_b(l1 >> 4, j2 >> 4)) {
                            float density = Math.min(pluton.getDensity(), 1.0f);
                            if (rand.nextFloat() > density) continue;
                            BlockState state = worldIn.func_180495_p(blockpos);
                            for (BlockState matcherState : pluton.getBlockStateMatchers() == null ? Utils.getDefaultMatchers() : pluton.getBlockStateMatchers()) {
                                if (!Utils.doStatesMatch(matcherState, state)) continue;
                                worldIn.func_180501_a(blockpos, pluton.getOre(), 18);
                                placed = true;
                                continue block3;
                            }
                            continue;
                        }
                        plutonCapability.putPendingBlock(new BlockPosDim(pos, Utils.dimensionToString(worldIn.func_201675_m())), pluton.getOre());
                    }
                }
            }
        }
        if (placed) {
            ((IGeolosysCapability)worldIn.func_201672_e().getCapability(GeolosysAPI.GEOLOSYS_WORLD_CAPABILITY).orElse(null)).setStonePlutonGenerated(new ChunkPosDim(pos, Objects.requireNonNull(worldIn.func_201675_m().func_186058_p().getRegistryName()).toString()));
        }
        return placed;
    }
}

