/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.api.world;

import com.oitsjustjose.geolosys.api.PlutonType;
import com.oitsjustjose.geolosys.api.world.DepositMultiOre;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class DepositMultiOreBiomeRestricted
extends DepositMultiOre {
    private List<Biome> biomes;
    private List<BiomeDictionary.Type> biomeTypes;
    private boolean useWhitelist;

    public DepositMultiOreBiomeRestricted(HashMap<BlockState, Integer> oreBlocks, HashMap<BlockState, Integer> sampleBlocks, int yMin, int yMax, int size, int chance, String[] dimFilter, boolean isDimFilterBl, HashSet<BlockState> blockStateMatchers, List<Biome> biomes, List<BiomeDictionary.Type> biomeTypes, boolean useWhitelist, PlutonType type, float density) {
        super(oreBlocks, sampleBlocks, yMin, yMax, size, chance, dimFilter, isDimFilterBl, blockStateMatchers, type, density);
        this.biomes = biomes;
        this.biomeTypes = biomeTypes;
        this.useWhitelist = useWhitelist;
    }

    public boolean canPlaceInBiome(Biome biome) {
        for (Biome b : this.biomes) {
            if (b != biome) continue;
            return true;
        }
        for (BiomeDictionary.Type type : this.biomeTypes) {
            RegistryKey regKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome.getRegistryName());
            Set dictTypes = BiomeDictionary.getTypes((RegistryKey)regKey);
            for (BiomeDictionary.Type otherType : dictTypes) {
                if (!type.getName().equalsIgnoreCase(otherType.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean useWhitelist() {
        return this.useWhitelist;
    }

    public boolean useBlacklist() {
        return !this.useWhitelist;
    }

    public List<Biome> getBiomeList() {
        return this.biomes;
    }

    public List<BiomeDictionary.Type> getBiomeTypes() {
        return this.biomeTypes;
    }
}

