/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.blocks;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class SampleBlock
extends Block
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public SampleBlock(Block parentOre) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151578_c, (MaterialColor)MaterialColor.field_197656_x).func_200948_a(0.125f, 2.0f).func_200947_a(SoundType.field_185849_b).harvestTool(ToolType.SHOVEL).func_222379_b(parentOre).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public SampleBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151578_c, (MaterialColor)MaterialColor.field_197656_x).func_200948_a(0.125f, 2.0f).func_200947_a(SoundType.field_185849_b).harvestTool(ToolType.SHOVEL));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        if (context.func_195991_k().func_180495_p(context.func_195995_a()).func_177230_c() == Blocks.field_150355_j) {
            return (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.TRUE);
        }
        return this.func_176223_P();
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Vector3d offset = state.func_191059_e(worldIn, pos);
        return VoxelShapes.func_197873_a((double)0.2, (double)0.0, (double)0.2, (double)0.8, (double)0.2, (double)0.8).func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance);
        Random random = new Random();
        if ((int)fallDistance > 0 && random.nextInt((int)fallDistance) > 5) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!player.func_213453_ef()) {
            worldIn.func_175655_b(pos, true);
            player.func_184609_a(handIn);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return Block.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177977_b(), (Direction)Direction.UP);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    @Nonnull
    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XZ;
    }

    @Nonnull
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (!this.func_196260_a(state, (IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        } else if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
    }

    public BlockState asWaterlogged() {
        return (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.TRUE);
    }
}

