/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.config;

import com.google.gson.stream.JsonReader;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.api.GeolosysAPI;
import com.oitsjustjose.geolosys.api.PlutonType;
import com.oitsjustjose.geolosys.api.world.Deposit;
import com.oitsjustjose.geolosys.api.world.DepositBiomeRestricted;
import com.oitsjustjose.geolosys.api.world.DepositMultiOre;
import com.oitsjustjose.geolosys.api.world.DepositMultiOreBiomeRestricted;
import com.oitsjustjose.geolosys.api.world.DepositStone;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;

public class OreConfig {
    private static OreConfig instance;
    private File jsonFile;

    public OreConfig(File configRoot) {
        this.jsonFile = new File(configRoot.getAbsolutePath() + "/geolosys.json");
    }

    public static void setup(File configRoot) {
        instance = new OreConfig(configRoot);
    }

    public static OreConfig getInstance() {
        if (instance == null) {
            throw new RuntimeException("Geolosys OreConfig has not yet been initialized!");
        }
        return instance;
    }

    public void init() {
        try {
            if (this.jsonFile.exists()) {
                FileInputStream jsonStream = new FileInputStream(this.jsonFile);
                this.read(jsonStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void read(InputStream in) throws IOException {
        try (JsonReader jReader = new JsonReader((Reader)new InputStreamReader(in));){
            jReader.beginObject();
            while (jReader.hasNext()) {
                int size;
                String name = jReader.nextName();
                if (name.equalsIgnoreCase("ores")) {
                    jReader.beginArray();
                    while (jReader.hasNext()) {
                        HashMap<String, Integer> oreBlocks = new HashMap<String, Integer>();
                        HashMap<String, Integer> sampleBlocks = new HashMap<String, Integer>();
                        int yMin = -1;
                        int yMax = -1;
                        size = -1;
                        int chance = -1;
                        String[] dimBlacklist = new String[]{};
                        ArrayList<String> blockStateMatchers = new ArrayList<String>();
                        ArrayList<Biome> biomes = new ArrayList<Biome>();
                        ArrayList<BiomeDictionary.Type> biomeTypes = new ArrayList<BiomeDictionary.Type>();
                        boolean isWhitelist = false;
                        boolean hasIsWhitelist = false;
                        PlutonType plutonType = null;
                        float density = 1.0f;
                        jReader.beginObject();
                        while (jReader.hasNext()) {
                            String subName = jReader.nextName();
                            if (subName.equalsIgnoreCase("blocks")) {
                                jReader.beginArray();
                                while (jReader.hasNext()) {
                                    oreBlocks.put(jReader.nextString(), jReader.nextInt());
                                }
                                jReader.endArray();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("samples")) {
                                jReader.beginArray();
                                while (jReader.hasNext()) {
                                    sampleBlocks.put(jReader.nextString(), jReader.nextInt());
                                }
                                jReader.endArray();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("yMin")) {
                                yMin = jReader.nextInt();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("yMax")) {
                                yMax = jReader.nextInt();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("size")) {
                                size = jReader.nextInt();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("chance")) {
                                chance = jReader.nextInt();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("dimBlacklist")) {
                                ArrayList<String> tmp = new ArrayList<String>();
                                jReader.beginArray();
                                while (jReader.hasNext()) {
                                    tmp.add(jReader.nextString());
                                }
                                jReader.endArray();
                                dimBlacklist = this.fromArrayList(tmp);
                                continue;
                            }
                            if (subName.equalsIgnoreCase("blockStateMatchers")) {
                                jReader.beginArray();
                                while (jReader.hasNext()) {
                                    blockStateMatchers.add(jReader.nextString());
                                }
                                jReader.endArray();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("biomes")) {
                                jReader.beginArray();
                                block16: while (jReader.hasNext()) {
                                    String testFor = jReader.nextString();
                                    Biome b = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(testFor.toLowerCase()));
                                    if (b != null) {
                                        biomes.add(b);
                                        continue;
                                    }
                                    for (BiomeDictionary.Type biomeType : BiomeDictionary.Type.getAll()) {
                                        if (!biomeType.getName().equalsIgnoreCase(testFor)) continue;
                                        biomeTypes.add(biomeType);
                                        continue block16;
                                    }
                                }
                                jReader.endArray();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("isWhitelist")) {
                                isWhitelist = jReader.nextBoolean();
                                hasIsWhitelist = true;
                                continue;
                            }
                            if (subName.equalsIgnoreCase("type")) {
                                String temp = jReader.nextString();
                                try {
                                    plutonType = PlutonType.valueOf(temp.toUpperCase());
                                }
                                catch (IllegalArgumentException e) {
                                    Geolosys.getInstance().LOGGER.info("The pluton type {} is not valid. Your possible choices are:\n{}\nGeolosys has chosen to use DENSE until this error is fixed", (Object)temp, (Object)Arrays.toString((Object[])PlutonType.values()));
                                    plutonType = PlutonType.DENSE;
                                }
                                continue;
                            }
                            if (subName.equalsIgnoreCase("density")) {
                                density = (float)jReader.nextDouble();
                                continue;
                            }
                            Geolosys.getInstance().LOGGER.info("Unknown property found in geolosys_ores.json file. Skipping it.");
                            jReader.skipValue();
                        }
                        if (!this.register(oreBlocks, sampleBlocks, yMin, yMax, size, chance, dimBlacklist, blockStateMatchers, biomes, biomeTypes, isWhitelist, hasIsWhitelist, plutonType, density)) {
                            Geolosys.getInstance().LOGGER.info("Could not register pluton " + oreBlocks + " due to some error. Please narrow down which block is not being registered on time by narrowing them down one-by-one.");
                        }
                        jReader.endObject();
                    }
                    jReader.endArray();
                    continue;
                }
                if (name.equalsIgnoreCase("stones")) {
                    jReader.beginArray();
                    while (jReader.hasNext()) {
                        jReader.beginObject();
                        String stone = null;
                        int yMin = -1;
                        int yMax = -1;
                        int chance = -1;
                        size = -1;
                        String[] dimBlacklist = new String[]{};
                        while (jReader.hasNext()) {
                            String subName = jReader.nextName();
                            if (subName.equalsIgnoreCase("block")) {
                                stone = jReader.nextString();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("yMin")) {
                                yMin = jReader.nextInt();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("yMax")) {
                                yMax = jReader.nextInt();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("size")) {
                                size = jReader.nextInt();
                                continue;
                            }
                            if (subName.equalsIgnoreCase("chance")) {
                                chance = jReader.nextInt();
                                continue;
                            }
                            if (!subName.equalsIgnoreCase("dimBlacklist")) continue;
                            ArrayList<String> tmp = new ArrayList<String>();
                            jReader.beginArray();
                            while (jReader.hasNext()) {
                                tmp.add(jReader.nextString());
                            }
                            jReader.endArray();
                            dimBlacklist = this.fromArrayList(tmp);
                        }
                        if (!this.register(stone, yMin, yMax, chance, size, dimBlacklist)) {
                            Geolosys.getInstance().LOGGER.info("Could not register pluton " + stone + " due to some error. Please report to the mod author that they are not initializing their blocks when they should..");
                        }
                        jReader.endObject();
                    }
                    jReader.endArray();
                    continue;
                }
                jReader.skipValue();
            }
            jReader.endObject();
        }
        catch (Exception e) {
            Geolosys.getInstance().LOGGER.error("There was a parsing error with the geolosys_ores.json file. Please check for drastic syntax errors and check it at https://jsonlint.com/");
            Geolosys.getInstance().LOGGER.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean register(String stone, int yMin, int yMax, int chance, int size, String[] dimBlacklist) {
        BlockState state = this.fromString(stone);
        if (state == null) {
            return false;
        }
        GeolosysAPI.plutonRegistry.addStonePluton(new DepositStone(state, yMin, yMax, chance, size, dimBlacklist, true));
        Geolosys.getInstance().LOGGER.info("Registered a stone pluton of {}.", (Object)stone);
        return true;
    }

    private boolean register(HashMap<String, Integer> oreBlocks, HashMap<String, Integer> sampleBlocks, int yMin, int yMax, int size, int chance, String[] dimBlacklist, ArrayList<String> blockStateMatchers, ArrayList<Biome> biomes, List<BiomeDictionary.Type> biomeTypes, boolean isWhitelist, boolean hasIsWhitelist, PlutonType type, float density) {
        Iterator<Object> iterator;
        BlockState b;
        Iterator<Object> iterator2;
        BlockState state;
        HashMap<BlockState, Integer> oreBlocksParsed = new HashMap<BlockState, Integer>();
        HashMap<BlockState, Integer> sampleBlocksParsed = new HashMap<BlockState, Integer>();
        HashSet<BlockState> blockStateMatchersParsed = new HashSet<BlockState>();
        IDeposit toRegister = null;
        for (Map.Entry<String, Integer> e : oreBlocks.entrySet()) {
            state = this.fromString(e.getKey());
            if (state == null) {
                return false;
            }
            oreBlocksParsed.put(state, e.getValue());
        }
        for (Map.Entry<String, Integer> e : sampleBlocks.entrySet()) {
            state = this.fromString(e.getKey());
            if (state == null) {
                return false;
            }
            sampleBlocksParsed.put(state, e.getValue());
        }
        for (String s : blockStateMatchers) {
            state = this.fromString(s);
            if (state == null) {
                return false;
            }
            blockStateMatchersParsed.add(state);
        }
        if (!(biomes.size() <= 0 && biomeTypes.size() <= 0 || hasIsWhitelist)) {
            return false;
        }
        if (type == null) {
            return false;
        }
        if (blockStateMatchersParsed.size() <= 0) {
            blockStateMatchersParsed = null;
        }
        if (oreBlocks.size() > 0 || sampleBlocks.size() > 0) {
            toRegister = biomes.size() > 0 || biomeTypes.size() > 0 ? new DepositMultiOreBiomeRestricted(oreBlocksParsed, sampleBlocksParsed, yMin, yMax, size, chance, dimBlacklist, true, blockStateMatchersParsed, biomes, biomeTypes, isWhitelist, type, density) : new DepositMultiOre(oreBlocksParsed, sampleBlocksParsed, yMin, yMax, size, chance, dimBlacklist, true, blockStateMatchersParsed, type, density);
        } else if (biomes.size() > 0 || biomeTypes.size() > 0) {
            iterator2 = oreBlocksParsed.keySet().iterator();
            if (iterator2.hasNext()) {
                b = (BlockState)iterator2.next();
                iterator = sampleBlocksParsed.keySet().iterator();
                if (iterator.hasNext()) {
                    BlockState s = (BlockState)iterator.next();
                    toRegister = new DepositBiomeRestricted(b, s, yMin, yMax, size, chance, dimBlacklist, true, blockStateMatchersParsed, biomes, biomeTypes, isWhitelist, type, density);
                }
            }
        } else {
            iterator2 = oreBlocksParsed.keySet().iterator();
            if (iterator2.hasNext()) {
                b = (BlockState)iterator2.next();
                iterator = sampleBlocksParsed.keySet().iterator();
                if (iterator.hasNext()) {
                    BlockState s = (BlockState)iterator.next();
                    toRegister = new Deposit(b, s, yMin, yMax, size, chance, dimBlacklist, true, blockStateMatchersParsed, type, density);
                }
            }
        }
        Geolosys.getInstance().LOGGER.info("Registered a {} ore pluton of blocks={}, samples={}, and density={}. This ore {} custom biome registries.", (Object)type.toString().toLowerCase(), oreBlocks, sampleBlocks, (Object)Float.valueOf(density), (Object)(biomeTypes.size() > 0 || biomes.size() > 0 ? "has" : "does not have"));
        return toRegister != null && GeolosysAPI.plutonRegistry.addOrePluton(toRegister);
    }

    private BlockState fromString(String iBlockState) {
        String[] parts = iBlockState.split(":");
        if (parts.length == 2) {
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(parts[0], parts[1]));
            return b.func_176223_P();
        }
        return null;
    }

    private String[] fromArrayList(ArrayList<String> arrList) {
        String[] ret = new String[arrList.size()];
        for (int i = 0; i < arrList.size(); ++i) {
            ret[i] = arrList.get(i);
        }
        return ret;
    }
}

