/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.data.modifiers;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class QuartzDropModifier
extends LootModifier {
    private Random rand = new Random();
    private HashMap<Item, Float> quartzes;
    private float chance;

    public QuartzDropModifier(ILootCondition[] conditions, HashMap<Item, Float> quartzes, float chance) {
        super(conditions);
        this.quartzes = quartzes;
        this.chance = chance;
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> gennedLoot, LootContext ctx) {
        if (this.rand.nextFloat() < this.chance) {
            gennedLoot.add(new ItemStack((IItemProvider)this.pick(), 1));
        }
        return gennedLoot;
    }

    private Item pick() {
        float rng = this.rand.nextFloat();
        float minDist = Float.MAX_VALUE;
        Item minDistItem = null;
        for (Map.Entry<Item, Float> e : this.quartzes.entrySet()) {
            float dist = Math.abs(e.getValue().floatValue() - rng);
            if (!(dist < minDist)) continue;
            minDist = dist;
            minDistItem = e.getKey();
        }
        return minDistItem;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<QuartzDropModifier> {
        public QuartzDropModifier read(ResourceLocation name, JsonObject obj, ILootCondition[] cond) {
            JsonArray a = JSONUtils.func_151214_t((JsonObject)obj, (String)"quartzes");
            HashMap<Item, Float> quartzes = new HashMap<Item, Float>();
            float occChance = JSONUtils.func_151217_k((JsonObject)obj, (String)"chance");
            a.forEach(el -> {
                JsonObject j = el.getAsJsonObject();
                String iName = j.get("item").getAsString();
                float chance = j.get("chance").getAsFloat();
                Item i = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(iName));
                if (i != null && i != Items.field_190931_a) {
                    quartzes.put(i, Float.valueOf(chance));
                }
            });
            return new QuartzDropModifier(cond, quartzes, occChance);
        }

        public JsonObject write(QuartzDropModifier instance) {
            return null;
        }
    }
}

