/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.data.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;

public class Utility {
    public static String[] getDimFilter(JsonObject obj) {
        if (obj.has("dimensions") && obj.get("dimensions").isJsonObject()) {
            return Utility.toStringArray(obj.get("dimensions").getAsJsonObject().get("filter").getAsJsonArray());
        }
        return Utility.toStringArray(obj.get("dimBlacklist").getAsJsonArray());
    }

    public static boolean getIsDimFilterBl(JsonObject obj) {
        if (obj.has("dimensions") && obj.get("dimensions").isJsonObject()) {
            return obj.get("dimensions").getAsJsonObject().get("isBlacklist").getAsBoolean();
        }
        return true;
    }

    public static JsonArray deconstructBiomes(List<Biome> biomes, List<BiomeDictionary.Type> types) {
        JsonArray ret = new JsonArray();
        for (Biome b : biomes) {
            ret.add(b.getRegistryName().toString());
        }
        for (BiomeDictionary.Type t : types) {
            ret.add(t.getName());
        }
        return ret;
    }

    @Nullable
    public static BlockState fromString(String string) {
        ResourceLocation r = new ResourceLocation(string);
        return ((Block)ForgeRegistries.BLOCKS.getValue(r)).func_176223_P();
    }

    public static String[] toStringArray(JsonArray arr) {
        String[] ret = new String[arr.size()];
        for (int i = 0; i < arr.size(); ++i) {
            ret[i] = arr.get(i).getAsString();
        }
        return ret;
    }

    public static HashSet<BlockState> toBlockStateList(JsonArray arr) {
        HashSet<BlockState> ret = new HashSet<BlockState>();
        for (String s : Utility.toStringArray(arr)) {
            ret.add(Utility.fromString(s));
        }
        return ret;
    }

    public static HashMap<BlockState, Integer> buildMultiBlockMap(JsonArray arr) {
        HashMap<BlockState, Integer> ret = new HashMap<BlockState, Integer>();
        for (JsonElement j : arr) {
            JsonObject pair = j.getAsJsonObject();
            ret.put(Utility.fromString(pair.get("block").getAsString()), pair.get("chance").getAsInt());
        }
        return ret;
    }

    public static JsonArray deconstructMultiBlockMap(HashMap<BlockState, Integer> in) {
        JsonArray ret = new JsonArray();
        for (Map.Entry<BlockState, Integer> e : in.entrySet()) {
            JsonObject obj = new JsonObject();
            obj.addProperty("block", e.getKey().func_177230_c().getRegistryName().toString());
            obj.addProperty("chance", (Number)e.getValue());
            ret.add((JsonElement)obj);
        }
        return ret;
    }

    public static List<BiomeDictionary.Type> extractBiomeTypes(JsonArray arr) {
        ArrayList<BiomeDictionary.Type> ret = new ArrayList<BiomeDictionary.Type>();
        block0: for (BiomeDictionary.Type biomeType : BiomeDictionary.Type.getAll()) {
            for (String type : Utility.toStringArray(arr)) {
                if (!biomeType.getName().equalsIgnoreCase(type)) continue;
                if (ret.contains(biomeType)) continue block0;
                ret.add(biomeType);
                continue block0;
            }
        }
        return ret;
    }

    public static List<Biome> extractBiomes(JsonArray arr) {
        ArrayList<Biome> ret = new ArrayList<Biome>();
        for (String s : Utility.toStringArray(arr)) {
            ResourceLocation r = new ResourceLocation(s.toLowerCase());
            if (!ForgeRegistries.BIOMES.containsKey(r)) continue;
            ret.add((Biome)ForgeRegistries.BIOMES.getValue(r));
        }
        return ret;
    }
}

