/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.utils;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.api.GeolosysAPI;
import com.oitsjustjose.geolosys.api.world.DepositBiomeRestricted;
import com.oitsjustjose.geolosys.api.world.DepositMultiOre;
import com.oitsjustjose.geolosys.api.world.DepositMultiOreBiomeRestricted;
import com.oitsjustjose.geolosys.api.world.DepositStone;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.ForgeRegistries;

public class Utils {
    private static HashSet<BlockState> defaultMatchersCached = null;

    public static ItemStack blockStateToStack(BlockState state) {
        return new ItemStack((IItemProvider)state.func_177230_c().func_199767_j(), 1);
    }

    public static boolean doStatesMatch(BlockState state1, BlockState state2) {
        return state1.func_177230_c().getRegistryName() == state2.func_177230_c().getRegistryName();
    }

    public static String dimensionToString(ISeedReader reader) {
        return reader.func_201672_e().func_234923_W_().func_240901_a_().toString();
    }

    public static BlockPos getTopSolidBlock(IWorld world, BlockPos start) {
        BlockPos retPos = new BlockPos(start.func_177958_n(), world.func_217301_I() - 1, start.func_177952_p());
        while (retPos.func_177956_o() > 0 && !world.func_180495_p(retPos).func_185904_a().func_76220_a()) {
            retPos = retPos.func_177977_b();
        }
        return retPos;
    }

    public static HashSet<BlockState> getDefaultMatchers() {
        if (defaultMatchersCached == null) {
            defaultMatchersCached = new HashSet();
            GeolosysAPI.plutonRegistry.getStones().forEach(x -> defaultMatchersCached.add(x.getOre()));
            ((List)CommonConfig.DEFAULT_REPLACEMENT_MATS.get()).forEach(s -> {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s));
                if (block == null || !Utils.addDefaultMatcher(block)) {
                    Geolosys.getInstance().LOGGER.warn("{} is not a valid block. Please verify.", s);
                }
            });
        }
        return (HashSet)defaultMatchersCached.clone();
    }

    public static boolean addDefaultMatcher(Block block) {
        BlockState defaultState = block.func_176223_P();
        if (!defaultState.func_196958_f()) {
            defaultMatchersCached.add(defaultState);
            return true;
        }
        return false;
    }

    public static boolean canMine(BlockState state, ItemStack stack) {
        int harvestLvl = stack.getHarvestLevel(ToolType.PICKAXE, null, null);
        return stack.getToolTypes().contains(ToolType.PICKAXE) && state.getHarvestLevel() <= harvestLvl;
    }

    public static void logDeposit(IDeposit dep) {
        if (dep instanceof DepositStone) {
            Geolosys.getInstance().LOGGER.info("Registered a {} stone pluton.", (Object)dep.getOre().func_177230_c().getRegistryName());
        } else if (dep instanceof DepositMultiOre) {
            Geolosys.getInstance().LOGGER.info("Registered a {} ore pluton with blocks={}, samples={}, and density={}. This ore {} custom biome registries.", (Object)dep.getPlutonType().toString().toLowerCase(), ((DepositMultiOre)dep).oreBlocks, ((DepositMultiOre)dep).sampleBlocks, (Object)Float.valueOf(dep.getDensity()), (Object)(dep instanceof DepositMultiOreBiomeRestricted ? "has" : "does not have"));
        } else {
            Geolosys.getInstance().LOGGER.info("Registered a {} {} ore pluton with sample {}, and density={}. This ore {} custom biome registries.", (Object)dep.getPlutonType().toString().toLowerCase(), (Object)dep.getOre().func_177230_c().getRegistryName(), (Object)dep.getSampleBlock().func_177230_c().getRegistryName(), (Object)Float.valueOf(dep.getDensity()), (Object)(dep instanceof DepositBiomeRestricted ? "has" : "does not have"));
        }
    }
}

