/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.world.feature.FeatureUtils;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.NoExposedOreFeature;
import net.minecraft.world.gen.feature.OreFeature;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;
import net.minecraft.world.gen.feature.ReplaceBlockFeature;

public class OreRemover {
    private static List<Block> toRm = Arrays.asList(Blocks.field_150366_p, Blocks.field_150365_q, Blocks.field_150369_x, Blocks.field_150482_ag, Blocks.field_150412_bA, Blocks.field_150352_o, Blocks.field_150450_ax, Blocks.field_196766_fg, Blocks.field_235334_I_, Blocks.field_235398_nh_, Blocks.field_196654_e, Blocks.field_196656_g, Blocks.field_196650_c, Blocks.field_196686_dc);
    public static List<Supplier<ConfiguredFeature<?, ?>>> removed = new LinkedList();

    private static void featureRemover(Block targetBlock, Supplier<ConfiguredFeature<?, ?>> targetFeature) {
        if (targetBlock != null && toRm.contains(targetBlock)) {
            removed.add(targetFeature);
            if (((Boolean)CommonConfig.DEBUG_WORLD_GEN.get()).booleanValue()) {
                Geolosys.getInstance().LOGGER.info(targetBlock.getRegistryName() + " : " + targetFeature.get().field_222737_a.getRegistryName() + " removed");
            }
        }
    }

    public static List<Supplier<ConfiguredFeature<?, ?>>> filterFeatures(List<Supplier<ConfiguredFeature<?, ?>>> features) {
        for (Supplier<ConfiguredFeature<?, ?>> feature : features) {
            OreFeatureConfig config;
            Block targetBlock = null;
            ConfiguredFeature<?, ?> targetFeature = FeatureUtils.getFeature(feature.get());
            if (targetFeature.field_222737_a instanceof OreFeature || targetFeature.field_222737_a instanceof NoExposedOreFeature) {
                config = (OreFeatureConfig)targetFeature.field_222738_b;
                targetBlock = config.field_202444_d.func_177230_c();
                OreRemover.featureRemover(targetBlock, feature);
                continue;
            }
            if (!(targetFeature.field_222737_a instanceof ReplaceBlockFeature)) continue;
            config = (ReplaceBlockConfig)targetFeature.field_222738_b;
            targetBlock = config.field_202458_b.func_177230_c();
            OreRemover.featureRemover(targetBlock, feature);
        }
        return removed;
    }
}

