/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world;

import com.mojang.serialization.Codec;
import com.oitsjustjose.geolosys.api.world.DepositBiomeRestricted;
import com.oitsjustjose.geolosys.api.world.DepositMultiOreBiomeRestricted;
import com.oitsjustjose.geolosys.api.world.DepositStone;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.world.OreRemover;
import com.oitsjustjose.geolosys.common.world.feature.FeatureUtils;
import com.oitsjustjose.geolosys.common.world.feature.PlutonOreFeature;
import com.oitsjustjose.geolosys.common.world.feature.PlutonStoneFeature;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlutonRegistry {
    private ArrayList<IDeposit> ores = new ArrayList();
    private ArrayList<IDeposit> oreWeightList = new ArrayList();
    private ArrayList<DepositStone> stones = new ArrayList();
    private ArrayList<DepositStone> stoneWeightList = new ArrayList();
    private static final List<GenerationStage.Decoration> decorations = new LinkedList<GenerationStage.Decoration>();

    public void clear() {
        this.ores = new ArrayList();
        this.oreWeightList = new ArrayList();
        this.stones = new ArrayList();
        this.stoneWeightList = new ArrayList();
    }

    public ArrayList<IDeposit> getOres() {
        return (ArrayList)this.ores.clone();
    }

    public ArrayList<IDeposit> getStones() {
        return (ArrayList)this.stones.clone();
    }

    public boolean addOrePluton(IDeposit ore) {
        if (ore instanceof DepositStone) {
            return this.addStonePluton((DepositStone)ore);
        }
        for (int i = 0; i < ore.getChance(); ++i) {
            this.oreWeightList.add(ore);
        }
        return this.ores.add(ore);
    }

    public boolean addStonePluton(DepositStone stone) {
        for (int i = 0; i < stone.getChance(); ++i) {
            this.stoneWeightList.add(stone);
        }
        return this.stones.add(stone);
    }

    public IDeposit pickPluton(ISeedReader reader, BlockPos pos, Random rand) {
        if (this.oreWeightList.size() > 0) {
            if (rand.nextBoolean()) {
                Biome b = reader.func_226691_t_(pos);
                ArrayList<IDeposit> forBiome = new ArrayList<IDeposit>();
                for (IDeposit d : this.ores) {
                    if (d instanceof DepositBiomeRestricted) {
                        if (!((DepositBiomeRestricted)d).canPlaceInBiome(b)) continue;
                        forBiome.add(d);
                        continue;
                    }
                    if (!(d instanceof DepositMultiOreBiomeRestricted) || !((DepositMultiOreBiomeRestricted)d).canPlaceInBiome(b)) continue;
                    forBiome.add(d);
                }
                if (forBiome.size() > 0) {
                    int pick = rand.nextInt(forBiome.size());
                    return (IDeposit)forBiome.get(pick);
                }
            }
            int pick = rand.nextInt(this.oreWeightList.size());
            return this.oreWeightList.get(pick);
        }
        return null;
    }

    public DepositStone pickStone() {
        if (this.stoneWeightList.size() > 0) {
            Random random = new Random();
            int pick = random.nextInt(this.stoneWeightList.size());
            return this.stoneWeightList.get(pick);
        }
        return null;
    }

    @SubscribeEvent
    public void onBiomesLoaded(BiomeLoadingEvent evt) {
        BiomeGenerationSettingsBuilder settings = evt.getGeneration();
        if (((Boolean)CommonConfig.REMOVE_VANILLA_ORES.get()).booleanValue()) {
            for (GenerationStage.Decoration deco : decorations) {
                FeatureUtils.destroyFeature(settings.getFeatures(deco), OreRemover.filterFeatures(settings.getFeatures(deco)));
            }
        }
        PlutonOreFeature o = new PlutonOreFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        PlutonStoneFeature s = new PlutonStoneFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        settings.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, o.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_));
        settings.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, s.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_));
    }

    static {
        decorations.add(GenerationStage.Decoration.UNDERGROUND_ORES);
        decorations.add(GenerationStage.Decoration.UNDERGROUND_DECORATION);
    }
}

