/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world;

import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.WorldGenRegion;

public class SampleUtils {
    private static ArrayList<BlockState> samplePlacementBlacklist = new ArrayList();
    private static Random random = new Random();

    @Nullable
    public static BlockPos getSamplePosition(IWorld iworld, ChunkPos chunkPos, int depositHeight) {
        if (!(iworld instanceof WorldGenRegion)) {
            return null;
        }
        WorldGenRegion world = (WorldGenRegion)iworld;
        int blockPosX = (chunkPos.field_77276_a << 4) + random.nextInt(16);
        int blockPosZ = (chunkPos.field_77275_b << 4) + random.nextInt(16);
        BlockPos searchPosUp = new BlockPos(blockPosX, world.func_181545_F(), blockPosZ);
        BlockPos searchPosDown = new BlockPos(blockPosX, world.func_181545_F(), blockPosZ);
        while (searchPosUp.func_177956_o() < world.func_217301_I()) {
            if (Block.func_220055_a((IWorldReader)world, (BlockPos)searchPosUp.func_177977_b(), (Direction)Direction.UP) && SampleUtils.canReplace((IWorld)world, searchPosUp) && SampleUtils.canReplace((IWorld)world, searchPosUp.func_177984_a()) && SampleUtils.canPlaceOn((IWorld)world, searchPosUp)) {
                return searchPosUp;
            }
            searchPosUp = searchPosUp.func_177984_a();
        }
        while (searchPosDown.func_177956_o() > 0) {
            if (Block.func_220055_a((IWorldReader)world, (BlockPos)searchPosDown.func_177977_b(), (Direction)Direction.UP) && SampleUtils.canReplace((IWorld)world, searchPosDown) && SampleUtils.canReplace((IWorld)world, searchPosDown.func_177984_a()) && SampleUtils.canPlaceOn((IWorld)world, searchPosDown)) {
                return searchPosDown;
            }
            searchPosDown = searchPosDown.func_177977_b();
        }
        return null;
    }

    public static boolean canPlaceOn(IWorld world, BlockPos pos) {
        return !samplePlacementBlacklist.contains(world.func_180495_p(pos.func_177977_b())) && Block.func_220055_a((IWorldReader)world, (BlockPos)pos.func_177977_b(), (Direction)Direction.UP);
    }

    public static boolean canReplace(IWorld world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Material mat = state.func_185904_a();
        return BlockTags.field_206952_E.func_230235_a_((Object)state.func_177230_c()) || mat.func_76222_j();
    }

    public static int getSampleCount(IDeposit ore) {
        int count = ore.getSize() / (Integer)CommonConfig.MAX_SAMPLES_PER_CHUNK.get() + ore.getSize() % (Integer)CommonConfig.MAX_SAMPLES_PER_CHUNK.get();
        return Math.min((Integer)CommonConfig.MAX_SAMPLES_PER_CHUNK.get(), count);
    }

    public static boolean isInWater(IWorld world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j;
    }

    public static boolean inNonWaterFluid(IWorld world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a().func_76224_d() && !SampleUtils.isInWater(world, pos);
    }

    public static boolean isWithinRange(int posA, int posB, int range) {
        return Math.abs(posA - posB) <= range;
    }

    public static void addSamplePlacementBlacklist(Block block) {
        samplePlacementBlacklist.add(block.func_176223_P());
    }
}

