/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world.capability;

import com.oitsjustjose.geolosys.api.BlockPosDim;
import com.oitsjustjose.geolosys.api.ChunkPosDim;
import com.oitsjustjose.geolosys.common.world.capability.IGeolosysCapability;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;

public class GeolosysCapability
implements IGeolosysCapability {
    private ConcurrentLinkedQueue<ChunkPosDim> oreGenMap = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<ChunkPosDim> stoneGenMap = new ConcurrentLinkedQueue();
    private Map<BlockPosDim, BlockState> pendingBlocks = new ConcurrentHashMap<BlockPosDim, BlockState>();
    private Map<UUID, Boolean> giveMap = new ConcurrentHashMap<UUID, Boolean>();

    @Override
    public ConcurrentLinkedQueue<ChunkPosDim> getOreGenMap() {
        return this.oreGenMap;
    }

    @Override
    public ConcurrentLinkedQueue<ChunkPosDim> getStoneGenMap() {
        return this.stoneGenMap;
    }

    @Override
    public Map<BlockPosDim, BlockState> getPendingBlocks() {
        return this.pendingBlocks;
    }

    @Override
    public void putPendingBlock(BlockPosDim pos, BlockState state) {
        this.pendingBlocks.put(pos, state);
    }

    @Override
    public BlockState getPendingBlock(BlockPosDim pos) {
        BlockState ret = this.pendingBlocks.get(pos);
        return ret;
    }

    @Override
    public void setOrePlutonGenerated(ChunkPosDim dim) {
        this.oreGenMap.add(dim);
    }

    @Override
    public boolean hasOrePlutonGenerated(ChunkPosDim pos) {
        return this.oreGenMap.contains(pos);
    }

    @Override
    public void setStonePlutonGenerated(ChunkPosDim pos) {
        this.stoneGenMap.add(pos);
    }

    @Override
    public boolean hasStonePlutonGenerated(ChunkPosDim pos) {
        return this.stoneGenMap.contains(pos);
    }

    @Override
    public boolean hasPlayerReceivedManual(UUID uuid) {
        return this.giveMap.containsKey(uuid);
    }

    @Override
    public void setPlayerReceivedManual(UUID uuid) {
        this.giveMap.put(uuid, true);
    }

    @Override
    public Map<UUID, Boolean> getGivenMap() {
        return this.giveMap;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("WorldOreDeposits", (INBT)new CompoundNBT());
        compound.func_218657_a("WorldStoneDeposits", (INBT)new CompoundNBT());
        compound.func_218657_a("PendingBlocks", (INBT)new CompoundNBT());
        compound.func_218657_a("PlayersGifted", (INBT)new CompoundNBT());
        CompoundNBT oreDeposits = compound.func_74775_l("WorldOreDeposits");
        CompoundNBT stoneDeposits = compound.func_74775_l("WorldStoneDeposits");
        CompoundNBT pendingBlocks = compound.func_74775_l("PendingBlocks");
        CompoundNBT playersGifted = compound.func_74775_l("PlayersGifted");
        this.getOreGenMap().forEach(x -> oreDeposits.func_74757_a(x.toString(), true));
        this.getStoneGenMap().forEach(x -> stoneDeposits.func_74757_a(x.toString(), true));
        this.getPendingBlocks().forEach((x, y) -> pendingBlocks.func_218657_a(x.toString(), (INBT)NBTUtil.func_190009_a((BlockState)y)));
        this.getGivenMap().forEach((x, y) -> playersGifted.func_74757_a(x.toString(), y.booleanValue()));
        return compound;
    }

    public void deserializeNBT(CompoundNBT compound) {
        CompoundNBT oreDeposits = compound.func_74775_l("WorldOreDeposits");
        CompoundNBT stoneDeposits = compound.func_74775_l("WorldStoneDeposits");
        CompoundNBT pendingBlocks = compound.func_74775_l("PendingBlocks");
        CompoundNBT playersGifted = compound.func_74775_l("PlayersGifted");
        oreDeposits.func_150296_c().forEach(key -> this.setOrePlutonGenerated(new ChunkPosDim((String)key)));
        stoneDeposits.func_150296_c().forEach(key -> this.setStonePlutonGenerated(new ChunkPosDim((String)key)));
        pendingBlocks.func_150296_c().forEach(key -> this.putPendingBlock(new BlockPosDim((String)key), NBTUtil.func_190008_d((CompoundNBT)((CompoundNBT)Objects.requireNonNull(pendingBlocks.func_74781_a(key))))));
        playersGifted.func_150296_c().forEach(key -> this.setPlayerReceivedManual(UUID.fromString(key)));
    }
}

