/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world.feature;

import com.oitsjustjose.geolosys.api.BlockPosDim;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.common.utils.Utils;
import com.oitsjustjose.geolosys.common.world.capability.IGeolosysCapability;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;

public class FeatureUtils {
    public static boolean isInChunk(ChunkPos chunkPos, BlockPos pos) {
        int blockX = pos.func_177958_n();
        int blockZ = pos.func_177952_p();
        return blockX >= chunkPos.func_180334_c() && blockX <= chunkPos.func_180332_e() && blockZ >= chunkPos.func_180333_d() && blockZ <= chunkPos.func_180330_f();
    }

    public static boolean isInChunk(ChunkPos chunkPos, BlockPosDim pos) {
        int blockX = pos.getX();
        int blockZ = pos.getZ();
        return blockX >= chunkPos.func_180334_c() && blockX <= chunkPos.func_180332_e() && blockZ >= chunkPos.func_180333_d() && blockZ <= chunkPos.func_180330_f();
    }

    public static ConfiguredFeature<?, ?> getFeature(ConfiguredFeature<?, ?> feature) {
        ConfiguredFeature currentFeature = feature;
        if (currentFeature.field_222737_a instanceof DecoratedFeature) {
            do {
                currentFeature = (ConfiguredFeature)((DecoratedFeatureConfig)currentFeature.func_242767_c()).field_214689_a.get();
            } while (currentFeature.field_222737_a instanceof DecoratedFeature);
        }
        return currentFeature;
    }

    public static void destroyFeature(List<Supplier<ConfiguredFeature<?, ?>>> features, List<Supplier<ConfiguredFeature<?, ?>>> destroy) {
        for (Supplier<ConfiguredFeature<?, ?>> feature : destroy) {
            features.remove(feature);
        }
    }

    public static boolean generateDense(ISeedReader reader, BlockPos pos, Random rand, IDeposit pluton, IGeolosysCapability plutonCapability) {
        int randY = pluton.getYMin() + rand.nextInt(pluton.getYMax() - pluton.getYMin());
        float f = rand.nextFloat() * (float)Math.PI;
        double d0 = (float)(pos.func_177958_n() + 8) + MathHelper.func_76126_a((float)f) * (float)pluton.getSize() / 8.0f;
        double d1 = (float)(pos.func_177958_n() + 8) - MathHelper.func_76126_a((float)f) * (float)pluton.getSize() / 8.0f;
        double d2 = (float)(pos.func_177952_p() + 8) + MathHelper.func_76134_b((float)f) * (float)pluton.getSize() / 8.0f;
        double d3 = (float)(pos.func_177952_p() + 8) - MathHelper.func_76134_b((float)f) * (float)pluton.getSize() / 8.0f;
        double d4 = randY + rand.nextInt(3) - 2;
        double d5 = randY + rand.nextInt(3) - 2;
        boolean placed = false;
        for (int i = 0; i < pluton.getSize(); ++i) {
            float f1 = (float)i / (float)pluton.getSize();
            double d6 = d0 + (d1 - d0) * (double)f1;
            double d7 = d4 + (d5 - d4) * (double)f1;
            double d8 = d2 + (d3 - d2) * (double)f1;
            double d9 = rand.nextDouble() * (double)pluton.getSize() / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * f1)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * f1)) + 1.0f) * d9 + 1.0;
            int j = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
            int k = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int l = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
            int i1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
            int j1 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int k1 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
            for (int l1 = j; l1 <= i1; ++l1) {
                double d12 = ((double)l1 + 0.5 - d6) / (d10 / 2.0);
                if (!(d12 * d12 < 1.0)) continue;
                for (int i2 = k; i2 <= j1; ++i2) {
                    double d13 = ((double)i2 + 0.5 - d7) / (d11 / 2.0);
                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                    block3: for (int j2 = l; j2 <= k1; ++j2) {
                        double d14 = ((double)j2 + 0.5 - d8) / (d10 / 2.0);
                        if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0)) continue;
                        BlockPos blockpos = new BlockPos(l1, i2, j2);
                        if (reader.func_217354_b(l1 >> 4, j2 >> 4)) {
                            float density = Math.min(pluton.getDensity(), 1.0f);
                            if (rand.nextFloat() > density) continue;
                            BlockState state = reader.func_180495_p(blockpos);
                            for (BlockState matcherState : pluton.getBlockStateMatchers() == null ? Utils.getDefaultMatchers() : pluton.getBlockStateMatchers()) {
                                if (!Utils.doStatesMatch(matcherState, state)) continue;
                                reader.func_180501_a(blockpos, pluton.getOre(), 18);
                                placed = true;
                                continue block3;
                            }
                            continue;
                        }
                        plutonCapability.putPendingBlock(new BlockPosDim(pos, Utils.dimensionToString(reader)), pluton.getOre());
                    }
                }
            }
        }
        return placed;
    }

    public static boolean generateSparse(ISeedReader reader, BlockPos pos, Random rand, IDeposit pluton, IGeolosysCapability plutonCapability) {
        ChunkPos thisChunk = new ChunkPos(pos);
        boolean placed = false;
        for (int y = pluton.getYMin(); y < pluton.getYMax(); ++y) {
            int numAttempts = rand.nextInt(pluton.getSize() / 3);
            block1: for (int attempt = 0; attempt < numAttempts; ++attempt) {
                int z;
                int x = pos.func_177958_n() + rand.nextInt(16);
                BlockPos blockpos = new BlockPos(x, y, z = pos.func_177952_p() + rand.nextInt(16));
                if (FeatureUtils.isInChunk(thisChunk, blockpos) && reader.func_217354_b(thisChunk.field_77276_a, thisChunk.field_77275_b)) {
                    float density = Math.min(pluton.getDensity(), 1.0f);
                    if (rand.nextFloat() > density) continue;
                    BlockState state = reader.func_180495_p(blockpos);
                    for (BlockState matcherState : pluton.getBlockStateMatchers() == null ? Utils.getDefaultMatchers() : pluton.getBlockStateMatchers()) {
                        if (!Utils.doStatesMatch(matcherState, state)) continue;
                        reader.func_180501_a(blockpos, pluton.getOre(), 18);
                        placed = true;
                        continue block1;
                    }
                    continue;
                }
                plutonCapability.putPendingBlock(new BlockPosDim(pos, Utils.dimensionToString(reader)), pluton.getOre());
            }
        }
        return placed;
    }

    public static boolean generateDike(ISeedReader reader, BlockPos pos, Random rand, IDeposit pluton, IGeolosysCapability plutonCapability) {
        ChunkPos thisChunk = new ChunkPos(pos);
        boolean placed = false;
        int height = Math.abs(pluton.getYMax() - pluton.getYMin());
        int x = thisChunk.func_180334_c() + rand.nextInt(16);
        int y = pluton.getYMin() + rand.nextInt(height);
        int z = thisChunk.func_180333_d() + rand.nextInt(16);
        BlockPos basePos = new BlockPos(x, y, z);
        int radius = pluton.getSize() / height > 0 ? pluton.getSize() / height : height / pluton.getSize();
        for (int dY = y; dY <= pluton.getYMax(); ++dY) {
            for (int dX = -radius; dX <= radius; ++dX) {
                block2: for (int dZ = -radius; dZ <= radius; ++dZ) {
                    float dist = dX * dX + dZ * dZ;
                    if (dist > (float)radius) continue;
                    BlockPos blockpos = new BlockPos(basePos.func_177958_n() + dX, dY, basePos.func_177952_p() + dZ);
                    if (FeatureUtils.isInChunk(thisChunk, blockpos) && reader.func_217354_b(thisChunk.field_77276_a, thisChunk.field_77275_b)) {
                        float density = Math.min(pluton.getDensity(), 1.0f);
                        if (rand.nextFloat() > density) continue;
                        BlockState state = reader.func_180495_p(blockpos);
                        for (BlockState matcherState : pluton.getBlockStateMatchers() == null ? Utils.getDefaultMatchers() : pluton.getBlockStateMatchers()) {
                            if (!Utils.doStatesMatch(matcherState, state)) continue;
                            reader.func_180501_a(blockpos, pluton.getOre(), 18);
                            placed = true;
                            continue block2;
                        }
                        continue;
                    }
                    plutonCapability.putPendingBlock(new BlockPosDim(pos, Utils.dimensionToString(reader)), pluton.getOre());
                    placed = true;
                }
            }
            if (rand.nextInt(100) % pluton.getSize() != 0 || --radius >= 0) continue;
            return placed;
        }
        return placed;
    }

    public static boolean generateLayer(ISeedReader reader, BlockPos pos, Random rand, IDeposit pluton, IGeolosysCapability plutonCapability) {
        ChunkPos thisChunk = new ChunkPos(pos);
        boolean placed = false;
        int x = (thisChunk.func_180334_c() + thisChunk.func_180332_e()) / 2 - rand.nextInt(8) + rand.nextInt(16);
        int y = pluton.getYMin() + rand.nextInt(Math.abs(pluton.getYMax() - pluton.getYMin()));
        int z = (thisChunk.func_180333_d() + thisChunk.func_180330_f()) / 2 - rand.nextInt(8) + rand.nextInt(16);
        int dXMod = rand.nextInt(pluton.getSize());
        int dZMod = rand.nextInt(pluton.getSize());
        BlockPos basePos = new BlockPos(x, y, z);
        int radius = pluton.getSize() / 2;
        int depth = Math.max(1 + rand.nextInt(1), pluton.getSize() / 5);
        for (int dX = -radius; dX <= radius; ++dX) {
            for (int dZ = -radius; dZ <= radius; ++dZ) {
                block2: for (int dY = 0; dY < depth; ++dY) {
                    float dist = (dX + dXMod) * (dX + dXMod) + (dZ + dZMod) * (dZ + dZMod);
                    if (dist > (float)radius) continue;
                    BlockPos blockpos = basePos.func_177982_a(dX, dY, dZ);
                    if (FeatureUtils.isInChunk(thisChunk, blockpos) && reader.func_217354_b(thisChunk.field_77276_a, thisChunk.field_77275_b)) {
                        float density = Math.min(pluton.getDensity(), 1.0f);
                        if (rand.nextFloat() > density) continue;
                        BlockState state = reader.func_180495_p(blockpos);
                        for (BlockState matcherState : pluton.getBlockStateMatchers() == null ? Utils.getDefaultMatchers() : pluton.getBlockStateMatchers()) {
                            if (!Utils.doStatesMatch(matcherState, state)) continue;
                            reader.func_180501_a(blockpos, pluton.getOre(), 18);
                            placed = true;
                            continue block2;
                        }
                        continue;
                    }
                    plutonCapability.putPendingBlock(new BlockPosDim(pos, Utils.dimensionToString(reader)), pluton.getOre());
                }
            }
        }
        return placed;
    }

    public static boolean generateTopLayer(ISeedReader reader, BlockPos pos, Random rand, IDeposit pluton, IGeolosysCapability plutonCapability) {
        ChunkPos thisChunk = new ChunkPos(pos);
        boolean placed = false;
        int x = (thisChunk.func_180334_c() + thisChunk.func_180332_e()) / 2 - rand.nextInt(8) + rand.nextInt(16);
        int z = (thisChunk.func_180333_d() + thisChunk.func_180330_f()) / 2 - rand.nextInt(8) + rand.nextInt(16);
        int radX = pluton.getSize() + rand.nextInt(Math.max(1, x % pluton.getSize()));
        int radZ = pluton.getSize() + rand.nextInt(Math.max(1, z % pluton.getSize()));
        BlockPos basePos = new BlockPos(x, 0, z);
        HashSet<BlockState> matchers = pluton.getBlockStateMatchers() == null ? Utils.getDefaultMatchers() : pluton.getBlockStateMatchers();
        for (int dX = -radZ; dX <= radZ; ++dX) {
            for (int dZ = -radZ; dZ <= radZ; ++dZ) {
                if (dX * dX + dZ * dZ > pluton.getSize() + rand.nextInt(Math.max(1, pluton.getSize() / 2))) continue;
                BlockPos blockPos = Utils.getTopSolidBlock((IWorld)reader, basePos.func_177982_a(dX, 0, dZ));
                block2: for (int i = 0; i < (radX + radZ) / 2 / 2; ++i) {
                    boolean isTopBlock;
                    boolean bl = isTopBlock = !reader.func_180495_p((blockPos = blockPos.func_177982_a(0, -i, 0)).func_177984_a()).func_200132_m();
                    if (FeatureUtils.isInChunk(thisChunk, blockPos) && reader.func_217354_b(thisChunk.field_77276_a, thisChunk.field_77275_b)) {
                        float density = Math.min(pluton.getDensity(), 1.0f);
                        if (rand.nextFloat() > density) continue;
                        BlockState state = reader.func_180495_p(blockPos);
                        for (BlockState matcherState : matchers) {
                            if (!Utils.doStatesMatch(matcherState, state)) continue;
                            BlockState toPlace = pluton.getOre();
                            if (pluton.getOre().func_235901_b_((Property)BlockStateProperties.field_222513_b)) {
                                toPlace = (BlockState)toPlace.func_206870_a((Property)BlockStateProperties.field_222513_b, (Comparable)Boolean.valueOf(reader.func_180495_p(blockPos.func_177984_a()).func_200132_m()));
                            }
                            reader.func_180501_a(blockPos, toPlace, 18);
                            if (isTopBlock && reader.func_180495_p(blockPos.func_177984_a()).func_185904_a() == Material.field_151579_a && rand.nextInt(5) == 0) {
                                reader.func_180501_a(blockPos.func_177984_a(), pluton.getSampleBlock(), 18);
                            }
                            placed = true;
                            continue block2;
                        }
                        continue;
                    }
                    plutonCapability.putPendingBlock(new BlockPosDim(pos, Utils.dimensionToString(reader)), pluton.getOre());
                }
            }
        }
        return placed;
    }
}

