/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world.feature;

import com.mojang.serialization.Codec;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.api.ChunkPosDim;
import com.oitsjustjose.geolosys.api.GeolosysAPI;
import com.oitsjustjose.geolosys.api.PlutonType;
import com.oitsjustjose.geolosys.api.world.DepositBiomeRestricted;
import com.oitsjustjose.geolosys.api.world.DepositMultiOre;
import com.oitsjustjose.geolosys.api.world.DepositMultiOreBiomeRestricted;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.utils.Utils;
import com.oitsjustjose.geolosys.common.world.SampleUtils;
import com.oitsjustjose.geolosys.common.world.capability.IGeolosysCapability;
import com.oitsjustjose.geolosys.common.world.feature.FeatureUtils;
import java.util.HashSet;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class PlutonOreFeature
extends Feature<NoFeatureConfig> {
    public PlutonOreFeature(Codec<NoFeatureConfig> p_i231976_1_) {
        super(p_i231976_1_);
    }

    @ParametersAreNonnullByDefault
    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        String[] restricted;
        if (generator instanceof FlatChunkGenerator) {
            return false;
        }
        IGeolosysCapability plutonCapability = (IGeolosysCapability)reader.func_201672_e().getCapability(GeolosysAPI.GEOLOSYS_WORLD_CAPABILITY).orElse(null);
        if (plutonCapability == null) {
            Geolosys.getInstance().LOGGER.error("NULL PLUTON CAPABILITY!!!");
            return false;
        }
        String dimName = Utils.dimensionToString(reader);
        plutonCapability.getPendingBlocks().forEach((pPos, pState) -> {
            if (FeatureUtils.isInChunk(new ChunkPos(pos), pPos)) {
                if (reader.func_180501_a(pPos.getPos(), pState, 18)) {
                    plutonCapability.getPendingBlocks().remove(pPos);
                    if (((Boolean)CommonConfig.DEBUG_WORLD_GEN.get()).booleanValue()) {
                        Geolosys.getInstance().LOGGER.info("Generated pending block " + pState.func_177230_c().getRegistryName().toString() + " at " + pos);
                    }
                } else if (((Boolean)CommonConfig.DEBUG_WORLD_GEN.get()).booleanValue()) {
                    Geolosys.getInstance().LOGGER.error("FAILED to generate pending block " + pState.func_177230_c().getRegistryName().toString() + " at " + pos);
                }
            }
        });
        ChunkPosDim chunkPosDim = new ChunkPosDim(pos, dimName);
        if (plutonCapability.hasOrePlutonGenerated(chunkPosDim)) {
            return false;
        }
        IDeposit pluton = GeolosysAPI.plutonRegistry.pickPluton(reader, pos, rand);
        if (pluton == null) {
            return false;
        }
        if (rand.nextInt((Integer)CommonConfig.CHUNK_SKIP_CHANCE.get()) > pluton.getChance()) {
            return false;
        }
        if (pluton instanceof DepositBiomeRestricted ? !(restricted = (DepositBiomeRestricted)pluton).canPlaceInBiome(reader.func_226691_t_(pos)) : pluton instanceof DepositMultiOreBiomeRestricted && !(restricted = (DepositMultiOreBiomeRestricted)pluton).canPlaceInBiome(reader.func_226691_t_(pos))) {
            return false;
        }
        for (String s : pluton.getDimensionFilter()) {
            boolean a = pluton.isDimensionFilterBlacklist();
            boolean b = dimName.equals(new ResourceLocation(s).toString());
            if ((!a || !b) && (a || b)) continue;
            return false;
        }
        boolean anyGenerated = false;
        switch (pluton.getPlutonType()) {
            case DENSE: {
                anyGenerated = FeatureUtils.generateDense(reader, pos, rand, pluton, plutonCapability);
                this.postPlacement(reader, pos, pluton);
                break;
            }
            case SPARSE: {
                anyGenerated = FeatureUtils.generateSparse(reader, pos, rand, pluton, plutonCapability);
                this.postPlacement(reader, pos, pluton);
                break;
            }
            case DIKE: {
                anyGenerated = FeatureUtils.generateDike(reader, pos, rand, pluton, plutonCapability);
                this.postPlacement(reader, pos, pluton);
                break;
            }
            case LAYER: {
                anyGenerated = FeatureUtils.generateLayer(reader, pos, rand, pluton, plutonCapability);
                this.postPlacement(reader, pos, pluton);
                break;
            }
            case TOP_LAYER: {
                anyGenerated = FeatureUtils.generateTopLayer(reader, pos, rand, pluton, plutonCapability);
            }
        }
        if (anyGenerated) {
            if (pluton.getPlutonType() == PlutonType.TOP_LAYER && rand.nextInt(10) == 0) {
                return this.generate(reader, generator, rand, pos, config);
            }
            plutonCapability.setOrePlutonGenerated(new ChunkPosDim(pos.func_177958_n(), pos.func_177952_p(), dimName));
            return true;
        }
        return false;
    }

    private void postPlacement(ISeedReader reader, BlockPos plutonStartPos, IDeposit ore) {
        if (((Boolean)CommonConfig.DEBUG_WORLD_GEN.get()).booleanValue()) {
            StringBuilder sb = new StringBuilder();
            String plutonSummary = "";
            if (ore instanceof DepositMultiOre) {
                DepositMultiOre d = (DepositMultiOre)ore;
                HashSet unique = new HashSet();
                d.getOres().forEach(e -> unique.add(e));
                unique.forEach(state -> {
                    sb.append(state.func_177230_c().getRegistryName().toString());
                    sb.append(", ");
                });
                plutonSummary = sb.toString();
                plutonSummary = plutonSummary.substring(0, plutonSummary.length() - 2);
            } else {
                plutonSummary = ore.getOre().func_177230_c().getRegistryName().toString();
            }
            Geolosys.getInstance().LOGGER.debug("Generated {} in Chunk {} (Pos [{} {} {}])", (Object)plutonSummary, (Object)new ChunkPos(plutonStartPos), (Object)plutonStartPos.func_177958_n(), (Object)plutonStartPos.func_177956_o(), (Object)plutonStartPos.func_177952_p());
        }
        int sampleLimit = SampleUtils.getSampleCount(ore);
        for (int i = 0; i < sampleLimit; ++i) {
            BlockPos samplePos = SampleUtils.getSamplePosition((IWorld)reader, new ChunkPos(plutonStartPos), ore.getYMax());
            if (samplePos == null || SampleUtils.inNonWaterFluid((IWorld)reader, samplePos) || reader.func_180495_p(samplePos) == ore.getSampleBlock()) continue;
            if (SampleUtils.isInWater((IWorld)reader, samplePos) && ore.getSampleBlock().func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                reader.func_180501_a(samplePos, (BlockState)ore.getSampleBlock().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.TRUE), 18);
                continue;
            }
            reader.func_180501_a(samplePos, ore.getSampleBlock(), 18);
        }
    }
}

