/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world.feature;

import com.mojang.serialization.Codec;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.api.ChunkPosDim;
import com.oitsjustjose.geolosys.api.GeolosysAPI;
import com.oitsjustjose.geolosys.api.world.DepositStone;
import com.oitsjustjose.geolosys.common.utils.Utils;
import com.oitsjustjose.geolosys.common.world.capability.IGeolosysCapability;
import com.oitsjustjose.geolosys.common.world.feature.FeatureUtils;
import java.util.Objects;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class PlutonStoneFeature
extends Feature<NoFeatureConfig> {
    public PlutonStoneFeature(Codec<NoFeatureConfig> p_i231976_1_) {
        super(p_i231976_1_);
    }

    @ParametersAreNonnullByDefault
    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (generator instanceof FlatChunkGenerator) {
            return false;
        }
        IGeolosysCapability plutonCapability = (IGeolosysCapability)reader.func_201672_e().getCapability(GeolosysAPI.GEOLOSYS_WORLD_CAPABILITY).orElse(null);
        if (plutonCapability == null) {
            Geolosys.getInstance().LOGGER.info("NULL PLUTON CAPABILITY!!!");
            return false;
        }
        ChunkPosDim chunkPosDim = new ChunkPosDim(pos, Objects.requireNonNull(Utils.dimensionToString(reader)));
        if (plutonCapability.hasStonePlutonGenerated(chunkPosDim)) {
            return false;
        }
        DepositStone pluton = GeolosysAPI.plutonRegistry.pickStone();
        if (pluton == null) {
            return false;
        }
        for (String s : pluton.getDimensionFilter()) {
            boolean a = pluton.isDimensionFilterBlacklist();
            boolean b = Utils.dimensionToString(reader).equals(new ResourceLocation(s).toString());
            if ((!a || !b) && (a || b)) continue;
            return false;
        }
        if (FeatureUtils.generateDense(reader, pos, rand, pluton, plutonCapability)) {
            plutonCapability.setStonePlutonGenerated(new ChunkPosDim(pos.func_177958_n(), pos.func_177952_p(), Utils.dimensionToString(reader)));
            return true;
        }
        return false;
    }
}

