/*
 * Decompiled with CFR 0.152.
 */
package ljfa.glassshards;

import ljfa.glassshards.Config;
import ljfa.glassshards.ModRecipes;
import ljfa.glassshards.glass.GlassRegistry;
import ljfa.glassshards.handlers.BreakSpeedHandler;
import ljfa.glassshards.handlers.HarvestDropsHandler;
import ljfa.glassshards.items.ItemGlassShards;
import ljfa.glassshards.items.ItemGlassSword;
import ljfa.glassshards.items.ModItems;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="glass_shards", name="Glass Shards", version="1.7", acceptedMinecraftVersions="[1.12,)", updateJSON="https://raw.githubusercontent.com/ljfa-ag/Glass-Shards/version/version.json")
public class GlassShards {
    @Mod.Instance(value="glass_shards")
    public static GlassShards instance;
    public static final Logger logger;
    public Item.ToolMaterial toolMatGlass;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.toolMatGlass = EnumHelper.addToolMaterial((String)"GLASS", (int)2, (int)Config.swordDurability, (float)4.0f, (float)2.0f, (int)5);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new HarvestDropsHandler());
        if (Config.increaseGlassBreakSpeed) {
            MinecraftForge.EVENT_BUS.register((Object)new BreakSpeedHandler());
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        GlassRegistry.registerAll();
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)new ItemGlassShards());
        if (Config.enableSword) {
            event.getRegistry().register((IForgeRegistryEntry)new ItemGlassSword());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        ModItems.glass_shards.registerModels();
        if (ModItems.glass_sword != null) {
            ModItems.glass_sword.registerModels();
        }
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ModRecipes.init();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("glass_shards".equals(event.getModID())) {
            ConfigManager.sync((String)"glass_shards", (Config.Type)Config.Type.INSTANCE);
        }
    }

    static {
        logger = LogManager.getLogger((String)"Glass Shards");
    }
}

