/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.entities.projectiles;

import com.mrbysco.instrumentalmobs.Reference;
import com.mrbysco.instrumentalmobs.config.InstrumentalConfig;
import com.mrbysco.instrumentalmobs.init.InstrumentalRegistry;
import com.mrbysco.instrumentalmobs.utils.InstrumentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class EntityMicrophoneWave
extends ThrowableEntity
implements IRendersAsItem {
    private SoundEvent sound = SoundEvents.field_189105_bM;
    private LivingEntity shootingEntity;

    public EntityMicrophoneWave(EntityType<? extends EntityMicrophoneWave> type, World worldIn) {
        super(type, worldIn);
    }

    public EntityMicrophoneWave(World worldIn, LivingEntity throwerIn, SoundEvent theSound) {
        super((EntityType)InstrumentalRegistry.MICROPHONE_WAVE.get(), throwerIn, worldIn);
        this.shootingEntity = throwerIn;
        this.sound = theSound;
    }

    public EntityMicrophoneWave(World worldIn, double x, double y, double z) {
        super((EntityType)InstrumentalRegistry.MICROPHONE_WAVE.get(), x, y, z, worldIn);
    }

    public EntityMicrophoneWave(FMLPlayMessages.SpawnEntity spawnEntity, World worldIn) {
        this((EntityType<? extends EntityMicrophoneWave>)((EntityType)InstrumentalRegistry.MICROPHONE_WAVE.get()), worldIn);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70227_a(RayTraceResult result) {
        super.func_70227_a(result);
        if (!this.field_70170_p.field_72995_K) {
            this.soundExplosion();
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        Entity entity = result.func_216348_a();
        if (entity instanceof PlayerEntity && this.shootingEntity instanceof PlayerEntity) {
            PlayerEntity playerIn = (PlayerEntity)this.shootingEntity;
            PlayerEntity collidingPlayer = (PlayerEntity)entity;
            if (playerIn.func_96122_a(collidingPlayer) && this.field_70170_p.field_73012_v.nextInt(10) <= 2) {
                collidingPlayer.func_70097_a(Reference.causeSoundDamage((Entity)this), 1.0f);
            }
        } else {
            entity.func_70097_a(Reference.causeSoundDamage((Entity)this), 6.0f);
            this.func_174815_a(this.shootingEntity, entity);
        }
    }

    public void soundExplosion() {
        this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), this.sound, this.func_184176_by(), 1.0f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197597_H, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
        if (((Boolean)InstrumentalConfig.COMMON.mobsReact.get()).booleanValue()) {
            InstrumentHelper.instrumentDamage(this.field_70170_p, (LivingEntity)this.func_234616_v_(), this.func_174813_aQ().func_186662_g(((Double)InstrumentalConfig.COMMON.instrumentRange.get()).doubleValue()));
        }
    }

    protected void func_70088_a() {
    }

    public ItemStack func_184543_l() {
        return new ItemStack((IItemProvider)InstrumentalRegistry.microphone.get());
    }
}

