/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.entities.projectiles;

import com.mrbysco.instrumentalmobs.Reference;
import com.mrbysco.instrumentalmobs.config.InstrumentalConfig;
import com.mrbysco.instrumentalmobs.init.InstrumentalRegistry;
import com.mrbysco.instrumentalmobs.utils.InstrumentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class EntitySoundWaves
extends DamagingProjectileEntity
implements IRendersAsItem {
    private SoundEvent sound = SoundEvents.field_189105_bM;

    public EntitySoundWaves(EntityType<? extends EntitySoundWaves> type, World worldIn) {
        super(type, worldIn);
    }

    public EntitySoundWaves(World worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super((EntityType)InstrumentalRegistry.SOUND_WAVE.get(), x, y, z, accelX, accelY, accelZ, worldIn);
    }

    public EntitySoundWaves(World worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super((EntityType)InstrumentalRegistry.SOUND_WAVE.get(), shooter, accelX, accelY, accelZ, worldIn);
    }

    public EntitySoundWaves(World worldIn, LivingEntity shooter, SoundEvent theSound) {
        super((EntityType)InstrumentalRegistry.SOUND_WAVE.get(), shooter, 1.0, 1.0, 1.0, worldIn);
        this.sound = theSound;
    }

    public EntitySoundWaves(FMLPlayMessages.SpawnEntity spawnEntity, World worldIn) {
        this((EntityType<? extends EntitySoundWaves>)((EntityType)InstrumentalRegistry.SOUND_WAVE.get()), worldIn);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70227_a(RayTraceResult result) {
        super.func_70227_a(result);
        if (!this.field_70170_p.field_72995_K) {
            this.soundExplosion();
            this.func_241204_bJ_();
        }
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        Entity entity = result.func_216348_a();
        if (entity instanceof PlayerEntity && this.func_234616_v_() instanceof PlayerEntity) {
            PlayerEntity collidingPlayer;
            PlayerEntity playerIn = (PlayerEntity)this.func_234616_v_();
            if (playerIn.func_96122_a(collidingPlayer = (PlayerEntity)entity) && this.field_70170_p.field_73012_v.nextInt(10) <= 2) {
                collidingPlayer.func_70097_a(Reference.causeSoundDamage((Entity)this), 1.0f);
            }
        } else if (this.func_234616_v_() instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)this.func_234616_v_();
            entity.func_70097_a(Reference.causeSoundDamage((Entity)this), 6.0f);
            this.func_174815_a(livingEntity, entity);
        }
    }

    public void soundExplosion() {
        this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), this.sound, this.func_184176_by(), 1.0f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197597_H, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
        if (((Boolean)InstrumentalConfig.COMMON.mobsReact.get()).booleanValue() && this.func_234616_v_() instanceof LivingEntity) {
            InstrumentHelper.instrumentDamage(this.field_70170_p, (LivingEntity)this.func_234616_v_(), this.func_174813_aQ().func_186662_g(((Double)InstrumentalConfig.COMMON.instrumentRange.get()).doubleValue()));
        }
    }

    public void shoot(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        Vector3d motion = this.func_213322_ci();
        Vector3d throwerMotion = this.func_234616_v_().func_213322_ci();
        double motionX = motion.field_72450_a + throwerMotion.field_72450_a;
        double motionY = motion.field_72448_b;
        double motionZ = motion.field_72449_c + throwerMotion.field_72449_c;
        if (!entityThrower.func_233570_aj_()) {
            motionY += throwerMotion.field_72448_b;
        }
        this.func_213293_j(motionX, motionY, motionZ);
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.func_213293_j(x *= (double)velocity, y *= (double)velocity, z *= (double)velocity);
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected void func_70088_a() {
    }

    public ItemStack func_184543_l() {
        return new ItemStack((IItemProvider)InstrumentalRegistry.microphone.get());
    }
}

