/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.instrumentalmobs.entities;

import com.mrbysco.instrumentalmobs.entities.IInstrumentalMobs;
import com.mrbysco.instrumentalmobs.entities.goals.InstrumentAttackGoal;
import com.mrbysco.instrumentalmobs.init.InstrumentalRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class MaracaSpiderEntity
extends Spider
implements IInstrumentalMobs {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(MaracaSpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public MaracaSpiderEntity(EntityType<? extends MaracaSpiderEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)InstrumentalRegistry.maraca.get()));
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)InstrumentalRegistry.maraca.get()));
        this.m_21409_(EquipmentSlot.MAINHAND, this.getDropChance());
        this.m_21409_(EquipmentSlot.OFFHAND, this.getDropChance());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new SpiderInstrumentAttack(this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new TargetGoal<Player>(this, Player.class));
        this.f_21346_.m_25352_(3, new TargetGoal<IronGolem>(this, IronGolem.class));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ATTACKING, (Object)false);
    }

    public void setAttacking(boolean isAttacking) {
        this.m_20088_().m_135381_(ATTACKING, (Object)isAttacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.m_20088_().m_135370_(ATTACKING);
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
        this.m_5496_((SoundEvent)InstrumentalRegistry.maraca_sound.get(), 0.15f, 1.0f);
    }

    static class SpiderInstrumentAttack
    extends InstrumentAttackGoal {
        public SpiderInstrumentAttack(MaracaSpiderEntity spider) {
            super((PathfinderMob)spider, 1.0, true, () -> (SoundEvent)InstrumentalRegistry.maraca_sound.get());
        }

        public boolean m_8045_() {
            float f = this.f_25540_.m_6073_();
            if (f >= 0.5f && this.f_25540_.m_21187_().nextInt(100) == 0) {
                this.f_25540_.m_6710_((LivingEntity)null);
                return false;
            }
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
            MaracaSpiderEntity spider = (MaracaSpiderEntity)this.f_25540_;
            spider.setAttacking(false);
            spider.f_20911_ = false;
        }

        public void m_8056_() {
            super.m_8056_();
            MaracaSpiderEntity spider = (MaracaSpiderEntity)this.f_25540_;
            spider.setAttacking(true);
            spider.m_6674_(InteractionHand.MAIN_HAND);
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 4.0f + attackTarget.m_20205_();
        }
    }

    static class TargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public TargetGoal(MaracaSpiderEntity spider, Class<T> classTarget) {
            super((Mob)spider, classTarget, true);
        }

        public boolean m_8036_() {
            float f = this.f_26135_.m_6073_();
            return !(f >= 0.5f) && super.m_8036_();
        }
    }
}

